/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.func.I_ParseFunc;
import org.jaymo_lang.util.Lib_Parser;

public class ParseFunc_Direct
implements I_ParseFunc {
    private static final String NO_OPEN_ARG = "+-*/%!=<>&|^~\u00b6\\";

    @Override
    public boolean hits(char c0, String s) {
        return c0 == '_' || c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z';
    }

    @Override
    public Group2<Call, String> parse(Parser_Script parser, Block current, I_Object obj, String s, boolean isArgument) {
        String m = Lib_Parser.getTypeName(s, parser);
        String rem = s.substring(m.length());
        String remTrimmed = rem.trim();
        Call[] argCalls = null;
        if (remTrimmed.length() > 0) {
            char r0 = rem.charAt(0);
            if (r0 == '(') {
                String args = Lib_Parser.group('(', ')', remTrimmed, parser.getDebugInfo());
                rem = remTrimmed.substring(1 + args.length() + 1);
                argCalls = Parser_Call.parseArguments(parser, current, args);
            } else {
                if (r0 == '\t') {
                    throw new ParseError("Invalid function call", "Please remove tab char before: " + remTrimmed, parser.getDebugInfo());
                }
                char rt0 = remTrimmed.charAt(0);
                if (rt0 != '.' && r0 == ' ' && NO_OPEN_ARG.indexOf(rt0) == -1) {
                    if (isArgument) {
                        throw new ParseError("Invalid use of open argument", "For nested argument, please try: ." + m + "( " + remTrimmed + " )", parser.getDebugInfo());
                    }
                    parser.app.strict.checkOpenArg(parser.getDebugInfo());
                    argCalls = Parser_Call.parseArguments(parser, current, remTrimmed);
                    if (argCalls.length != 1) {
                        throw new ParseError("Invalid use of open argument", "For more arguments, please try: ." + m + "( " + remTrimmed + " )", parser.getDebugInfo());
                    }
                    if (parser.buffer.nextLevelDiff() > 0 || argCalls[0].hasBlock()) {
                        throw new ParseError("Invalid use of open argument", "For using block, please try: ." + m + "( " + remTrimmed + " )", parser.getDebugInfo());
                    }
                    if (argCalls[0].hasStream()) {
                        throw new ParseError("Invalid use of open argument", "For using stream, please try: ." + m + "( " + remTrimmed + " )", parser.getDebugInfo());
                    }
                    if (argCalls[0].method != null) {
                        throw new ParseError("Invalid use of open argument", "No method allowed, please try: ." + m + "( " + remTrimmed + " )", parser.getDebugInfo());
                    }
                    rem = null;
                }
            }
        }
        Call c = new Call(current, obj, m, argCalls, parser.getDebugInfo());
        return new Group2<Call, String>(c, rem);
    }
}

