/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.magic.var;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MFile;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.magic.I_MagicReplace;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public class MV_APP
extends A_MagicVar
implements I_Object,
I_MagicReplace {
    public static final String ID = "app";

    public MV_APP() {
        super(false);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return "App";
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        cr.getApp().strict.checkSandbox(cr, ID);
        if (method.startsWith("::@")) {
            return cr.getApp().call(cr);
        }
        switch (method) {
            case "setOutput": {
                return A_Object.stdResult(this.mSetOutput(cr));
            }
            case "resetOutput": {
                return A_Object.stdResult(this.mResetOutput(cr));
            }
            case "getArgs": {
                return A_Object.stdResult(cr.getApp().getArgs());
            }
            case "=": {
                return this.mExit(cr, 1, 1);
            }
            case "exit": {
                return this.mExit(cr, 0, 1);
            }
            case "keep": {
                return this.mKeep(cr);
            }
            case "exec": {
                return A_Object.stdResult(this.mExec(cr));
            }
        }
        return null;
    }

    private ObjectCallResult mExit(CallRuntime cr, int parsMin, int parsMax) {
        I_Object[] args = cr.argsFlex(this, parsMin, parsMax);
        int exitState = 0;
        if (args.length == 1) {
            I_Object arg = cr.argType(args[0], Int.class);
            exitState = ((Int)arg).getValue();
        }
        I_Object result = cr.getApp().exit(cr, exitState);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mKeep(CallRuntime cr) {
        cr.argsNone();
        cr.getApp().setKeep(cr);
        return new ObjectCallResult(this, false);
    }

    private I_Atomic mExec(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String value = Lib_Convert.getStringValue(cr, arg);
        cr.getStrict().checkUnsafeHotCode(cr, "app.exec");
        return Lib_Exec.execJayMoHot(cr, value, "app.exec");
    }

    private I_Object mSetOutput(CallRuntime cr) {
        I_Object[] args = cr.argsExt(this, {JMo_File.class, Str.class}, {Bool.class});
        String file = args[0] instanceof Str ? Lib_Convert.getStringValue(cr, args[0]) : ((JMo_File)args[0]).getInternalFile().getAbsolutePath();
        MFile file2 = new MFile(file);
        cr.getApp().setOutputFile(file2);
        boolean clear = ((Bool)args[1]).getValue();
        if (clear) {
            try {
                Lib_TextFile.set(cr.getApp().getOutputFile().getFile(), "", true);
            }
            catch (Err_FileSys e) {
                Err.show(e);
            }
        }
        return this;
    }

    private I_Object mResetOutput(CallRuntime cr) {
        cr.argsNone();
        cr.getApp().setOutputFile(null);
        return this;
    }
}

