/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.tcp;

import de.mn77.base.error.Err;
import de.mn77.lib.tcp.TCP_Client;
import de.mn77.lib.tcp.TCP_Connection;
import java.io.IOException;
import org.jaymo_lang.lib.tcp.JMo_TcpConnection;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_TcpClient
extends A_EventObject {
    private TCP_Client client;
    private final ArgCallBuffer par_address;
    private final ArgCallBuffer par_port;

    public JMo_TcpClient(Call address, Call port) {
        this.par_address = new ArgCallBuffer(0, address);
        this.par_port = new ArgCallBuffer(1, port);
    }

    @Override
    public void init(CallRuntime cr) {
        String address = Lib_Convert.getStringValue(cr, this.par_address.init(cr, this, Str.class));
        int port = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.client = new TCP_Client(address, port);
        }
        catch (IOException e) {
            Err.exit(e);
        }
        this.client.onTimeOut(ste -> {
            JMo_Error e = new JMo_Error((Throwable)ste);
            this.eventRun(cr, "@timeout", e);
        });
        this.client.onError(ioe -> {
            JMo_Error e = new JMo_Error((Throwable)ioe);
            this.eventRun(cr, "@error", e);
        });
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "connect": {
                cr.argsNone();
                TCP_Connection con = this.client.connect();
                return A_Object.stdResult(con == null ? Nil.NIL : new JMo_TcpConnection(con));
            }
        }
        return null;
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@timeout": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return type == STYPE.NESTED ? super.toString() : String.valueOf(super.toString()) + "(\"" + this.par_address.get() + "\":" + this.par_port.get() + ")";
    }
}

