/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.graphic;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.lib.graphic.IMAGE_FORMAT;
import de.mn77.lib.graphic.I_ImageX;
import de.mn77.lib.graphic.MImageX;
import java.awt.Color;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExtError;
import org.jaymo_lang.lib.graphic.JMo_Color;
import org.jaymo_lang.lib.graphic.JMo_ColorRGB;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Image
extends A_ObjectSimple {
    private final ArgCallBuffer par1;
    private final ArgCallBuffer par2;
    private I_ImageX image = null;

    public JMo_Image(Call image) {
        this.par1 = new ArgCallBuffer(0, image);
        this.par2 = null;
    }

    public JMo_Image(Call dx, Call dy) {
        this.par1 = new ArgCallBuffer(0, dx);
        this.par2 = new ArgCallBuffer(1, dy);
    }

    public JMo_Image(I_ImageX init) {
        this.image = init;
        this.par1 = null;
        this.par2 = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par1 != null && this.par2 != null) {
            A_IntNumber odx = this.par1.init(cr, this, A_IntNumber.class);
            A_IntNumber ody = this.par2.init(cr, this, A_IntNumber.class);
            int dx = Lib_Convert.getIntValue(cr, odx);
            int dy = Lib_Convert.getIntValue(cr, ody);
            this.image = new MImageX(dx, dy, 0, 0, 0, 0);
            return;
        }
        if (this.par1 != null && this.par2 == null) {
            I_Object o1 = this.par1.initExt(cr, this, Str.class, JMo_File.class, JMo_ByteArray.class);
            Object o2 = null;
            if (o1 instanceof Str) {
                o2 = Lib_Convert.getStringValue(cr, o1);
            } else if (o1 instanceof JMo_File) {
                o2 = ((JMo_File)Lib_Convert.getValue(cr, o1)).getInternalFile();
            } else if (o1 instanceof JMo_ByteArray) {
                o2 = ((JMo_ByteArray)Lib_Convert.getValue(cr, o1)).getValue();
            } else {
                Err.impossible(o2);
            }
            try {
                Err.ifNull(o2);
                this.image = new MImageX(o2);
            }
            catch (Exception e) {
                Err.show(e);
                new ExtError(cr, "Opening Image failed", e.getMessage());
            }
            return;
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "getWidth": {
                cr.argsNone();
                return new Int(this.image.getWidth());
            }
            case "getHeight": {
                cr.argsNone();
                return new Int(this.image.getHeight());
            }
            case "copy": {
                cr.argsNone();
                return new JMo_Image(this.image.copy());
            }
            case "clear": {
                cr.argsNone();
                this.iFillRGBA(0, 0, 0, null);
                return this;
            }
            case "fill": {
                this.iFill(cr);
                return this;
            }
            case "writePNG": 
            case "writePng": {
                String dest = ((Str)cr.args(this, Str.class)[0]).getValue();
                try {
                    this.image.save(dest, IMAGE_FORMAT.PNG, false);
                }
                catch (Err_FileSys e) {
                    new ExtError(cr, "Write-Error", e.getMessage());
                }
                return this;
            }
            case "writeJPG": 
            case "writeJpg": {
                I_Object[] parsJpg = cr.argsFlex(this, 1, 2);
                String dest2 = ((Str)cr.argType(parsJpg[0], Str.class)).getValue();
                try {
                    if (parsJpg.length == 2) {
                        int quality = Lib_Convert.getIntValue(cr, cr.argType(parsJpg[1], A_IntNumber.class));
                        this.image.saveJPEG(dest2, quality, false);
                    } else {
                        this.image.saveJPEG(dest2, false);
                    }
                }
                catch (Err_FileSys e) {
                    new ExtError(cr, "Write-Error", e.getMessage());
                }
                return this;
            }
            case "scale": {
                I_Object[] pars2 = cr.args(this, A_IntNumber.class, A_IntNumber.class);
                int dx2 = Lib_Convert.getIntValue(cr, pars2[0]);
                int dy2 = Lib_Convert.getIntValue(cr, pars2[1]);
                this.image.scale(dx2, dy2);
                return this;
            }
            case "distort": {
                I_Object[] pars3 = cr.args(this, A_IntNumber.class, A_IntNumber.class);
                int dx3 = Lib_Convert.getIntValue(cr, pars3[0]);
                int dy3 = Lib_Convert.getIntValue(cr, pars3[1]);
                this.image.distort(dx3, dy3);
                return this;
            }
            case "cut": {
                I_Object[] pars4 = cr.argsFlex(this, 3, 5);
                int dx4 = Lib_Convert.getIntValue(cr, cr.argType(pars4[0], A_IntNumber.class));
                int dy4 = Lib_Convert.getIntValue(cr, cr.argType(pars4[1], A_IntNumber.class));
                POSITION grav = ((MagicPosition)cr.argType(pars4[2], MagicPosition.class)).get();
                if (pars4.length == 4) {
                    throw new CodeError(cr, "Invalid count of parameters", "Need 3 or 5, got " + pars4.length);
                }
                if (pars4.length == 3) {
                    this.image.cut(dx4, dy4, grav);
                } else {
                    int ox = Lib_Convert.getIntValue(cr, cr.argType(pars4[3], A_IntNumber.class));
                    int oy = Lib_Convert.getIntValue(cr, cr.argType(pars4[4], A_IntNumber.class));
                    this.image.cut(dx4, dy4, grav, ox, oy, Color.BLACK);
                }
                return this;
            }
            case "fade": 
            case "brightness": {
                I_Object[] pars5 = cr.args(this, A_IntNumber.class);
                int p5 = Lib_Convert.getIntValue(cr, pars5[0]);
                this.image.brightness(p5);
                return this;
            }
            case "contrast": {
                I_Object[] pars6 = cr.args(this, A_IntNumber.class);
                int p6 = Lib_Convert.getIntValue(cr, pars6[0]);
                this.image.contrast(p6);
                return this;
            }
            case "invert": 
            case "negative": {
                cr.argsNone();
                this.image.negative();
                return this;
            }
            case "gamma": {
                I_Object[] pars7 = cr.args(this, A_Number.class);
                double p7 = Lib_Convert.getDoubleValue(cr, pars7[0]);
                this.image.gamma(p7);
                return this;
            }
            case "flipX": {
                cr.argsNone();
                this.image.flipX();
                return this;
            }
            case "flipY": {
                cr.argsNone();
                this.image.flipY();
                return this;
            }
            case "rotate": {
                I_Object[] pars8 = cr.argsFlex(this, 1, 2);
                I_Object pars8_0 = cr.argType(pars8[0], A_Number.class);
                double p8 = Lib_Convert.getDoubleValue(cr, pars8_0);
                if (pars8.length == 1) {
                    this.image.rotate(p8);
                } else {
                    JMo_ColorRGB col = (JMo_ColorRGB)cr.argType(pars8[1], JMo_ColorRGB.class);
                    this.image.rotate(p8, col.getColor());
                }
                return this;
            }
            case "add": {
                I_Object[] pars9 = cr.argsFlex(this, 2, 4);
                JMo_Image image9 = (JMo_Image)cr.argType(pars9[0], JMo_Image.class);
                POSITION grav9 = ((MagicPosition)cr.argType(pars9[1], MagicPosition.class)).get();
                if (pars9.length == 3) {
                    throw new CodeError(cr, "Invalid count of parameters", "Need 2 or 4, got " + pars9.length);
                }
                if (pars9.length == 2) {
                    this.image.add(image9.image, grav9);
                } else {
                    int ox = Lib_Convert.getIntValue(cr, cr.argType(pars9[2], A_IntNumber.class));
                    int oy = Lib_Convert.getIntValue(cr, cr.argType(pars9[3], A_IntNumber.class));
                    this.image.add(image9.image, grav9, ox, oy);
                }
                return this;
            }
            case "toByteArray": 
            case "getBytes": {
                return new JMo_ByteArray(this.image.getBytesPNG());
            }
        }
        return null;
    }

    private void iFill(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 4);
        int argsLen = args.length;
        int r = 0;
        int g = 0;
        int b = 0;
        if (argsLen == 1 || argsLen == 2) {
            Color col = ((JMo_Color)cr.argType(args[0], JMo_Color.class)).getColor();
            r = col.getRed();
            g = col.getGreen();
            b = col.getBlue();
        } else {
            r = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class));
            g = Lib_Convert.getIntValue(cr, cr.argType(args[1], A_IntNumber.class));
            b = Lib_Convert.getIntValue(cr, cr.argType(args[2], A_IntNumber.class));
        }
        if (argsLen == 2 || argsLen == 4) {
            int a = Lib_Convert.getIntValue(cr, cr.argType(args[argsLen - 1], A_IntNumber.class));
            this.iFillRGBA(r, g, b, a);
        } else {
            this.iFillRGBA(r, g, b, null);
        }
    }

    private void iFillRGBA(int r, int g, int b, Integer a) {
        Err.ifOutOfBounds(0.0, 255.0, r);
        Err.ifOutOfBounds(0.0, 255.0, g);
        Err.ifOutOfBounds(0.0, 255.0, b);
        int dx = this.image.getWidth();
        int dy = this.image.getHeight();
        if (a != null) {
            Err.ifOutOfBounds(0.0, 255.0, a.intValue());
            this.image = new MImageX(dx, dy, r, g, b, a);
        } else {
            this.image = new MImageX(dx, dy, r, g, b);
        }
    }

    public I_ImageX internalGet() {
        return this.image;
    }
}

