/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.graphic;

import de.mn77.base.data.Lib_Math;
import de.mn77.lib.graphic.Lib_Graphic;
import java.awt.Color;
import org.jaymo_lang.lib.graphic.JMo_Color;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Type;

public class JMo_ColorHSV
extends JMo_Color {
    private final ArgCallBuffer par1;
    private final ArgCallBuffer par2;
    private final ArgCallBuffer par3;
    private int hue = -1;
    private double saturation = -1.0;
    private double value = -1.0;

    public JMo_ColorHSV() {
        this(Color.black);
    }

    public JMo_ColorHSV(Color c) {
        this.par1 = null;
        this.par2 = null;
        this.par3 = null;
        float[] hsv = Lib_Graphic.RGBtoHSV(c.getRed(), c.getGreen(), c.getBlue());
        this.hue = Math.round(hsv[0]);
        this.saturation = hsv[1];
        this.value = hsv[2];
    }

    public JMo_ColorHSV(Call p1, Call p2, Call p3) {
        this.par1 = new ArgCallBuffer(0, p1);
        this.par2 = new ArgCallBuffer(1, p2);
        this.par3 = new ArgCallBuffer(2, p3);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par1 != null && this.par2 != null && this.par3 != null) {
            A_IntNumber po1 = this.par1.init(cr, this, A_IntNumber.class);
            A_Number po2 = this.par2.init(cr, this, A_Number.class);
            A_Number po3 = this.par3.init(cr, this, A_Number.class);
            double pi1 = Lib_Convert.getDoubleValue(cr, po1);
            double pi2 = Lib_Convert.getDoubleValue(cr, po2);
            double pi3 = Lib_Convert.getDoubleValue(cr, po3);
            Lib_Error.ifNotBetween(cr, 0.0, 360.0, pi1, "Value for hue");
            Lib_Error.ifNotBetween(cr, 0.0, 1.0, pi2, "Value for saturation");
            Lib_Error.ifNotBetween(cr, 0.0, 1.0, pi3, "Value for brightness");
            this.hue = Lib_Math.roundToInt(pi1);
            this.saturation = pi2;
            this.value = pi3;
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "getHue": {
                cr.argsNone();
                return new Int(this.hue);
            }
            case "getSaturation": {
                cr.argsNone();
                return new Dec(this.saturation);
            }
            case "getBrightness": 
            case "getValue": {
                cr.argsNone();
                return new Dec(this.value);
            }
        }
        return null;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: {
                return Lib_Type.getName(this);
            }
            case DESCRIBE: {
                return String.valueOf(Lib_Type.getName(this)) + "(" + this.hue + "i," + Lib_Math.round(this.saturation, 5) + "d," + Lib_Math.round(this.value, 5) + "d)";
            }
        }
        return String.valueOf(Lib_Type.getName(this)) + "(" + this.hue + "," + Lib_Math.round(this.saturation, 5) + "," + Lib_Math.round(this.value, 5) + ")";
    }

    @Override
    public Color getColor() {
        int[] rgb = Lib_Graphic.HSVtoRGB(this.hue, (float)this.saturation, (float)this.value);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

