/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.bricklink;

import de.mn77.lib.crypt.Lib_Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BLAuthSigner {
    private static final String CHARSET = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String EMPTY_STRING = "";
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final String signMethod = "HMAC-SHA1";
    private static final String version = "1.0";
    private final String consumerKey;
    private final String consumerSecret;
    private String tokenValue;
    private String tokenSecret;
    private String url;
    private String verb;
    private final Map<String, String> oauthParameters;
    private final Map<String, String> queryParameters;
    private final Timer timer;

    public BLAuthSigner(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.oauthParameters = new HashMap<String, String>();
        this.queryParameters = new HashMap<String, String>();
        this.timer = new Timer();
    }

    public void setToken(String tokenValue, String tokenSecret) {
        this.tokenValue = tokenValue;
        this.tokenSecret = tokenSecret;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public void addParameter(String key, String value) {
        this.queryParameters.put(key, value);
    }

    public Map<String, String> getFinalOAuthParams() throws Exception {
        String signature = this.computeSignature();
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.oauthParameters);
        params.put("oauth_signature", signature);
        return params;
    }

    public String computeSignature() throws Exception {
        this.addOAuthParameter("oauth_version", version);
        this.addOAuthParameter("oauth_timestamp", this.getTimestampInSeconds());
        this.addOAuthParameter("oauth_nonce", this.getNonce());
        this.addOAuthParameter("oauth_token", this.tokenValue);
        this.addOAuthParameter("oauth_consumer_key", this.consumerKey);
        this.addOAuthParameter("oauth_signature_method", signMethod);
        String baseString = this.getBaseString();
        String keyString = String.valueOf(OAuthEncoder.encode(this.consumerSecret)) + '&' + OAuthEncoder.encode(this.tokenSecret);
        String signature = this.doSign(baseString, keyString);
        return signature;
    }

    private void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(key, value);
    }

    private String getTimestampInSeconds() {
        Long ts = this.timer.getMilis();
        return String.valueOf(TimeUnit.MILLISECONDS.toSeconds(ts));
    }

    private String getNonce() {
        Long ts = this.timer.getMilis();
        return String.valueOf(String.valueOf(ts)) + String.valueOf(Math.abs(this.timer.getRandomInteger()));
    }

    private String getBaseString() throws Exception {
        Object param;
        ArrayList<Object> params = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : this.oauthParameters.entrySet()) {
            param = OAuthEncoder.encode(entry.getKey()).concat("=").concat(entry.getValue());
            params.add(param);
        }
        for (Map.Entry<String, String> entry : this.queryParameters.entrySet()) {
            param = OAuthEncoder.encode(entry.getKey()).concat("=").concat(entry.getValue());
            params.add(param);
        }
        Collections.sort(params);
        StringBuilder builder = new StringBuilder();
        for (String string : params) {
            builder.append('&').append(string);
        }
        String string = OAuthEncoder.encode(builder.toString().substring(1));
        String sanitizedURL = OAuthEncoder.encode(this.url.replaceAll("\\?.*", EMPTY_STRING).replace("\\:\\d{4}", EMPTY_STRING));
        return String.format("%s&%s&%s", this.verb, sanitizedURL, string);
    }

    private String doSign(String toSign, String keyString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(CHARSET), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] bytes = mac.doFinal(toSign.getBytes(CHARSET));
        return this.bytesToBase64String(bytes).replace(CARRIAGE_RETURN, EMPTY_STRING);
    }

    private String bytesToBase64String(byte[] bytes) throws Exception {
        return new String(Lib_Base64.encode(bytes), CHARSET);
    }

    static class OAuthEncoder {
        private static final Map<String, String> ENCODING_RULES;

        static {
            HashMap<String, String> rules = new HashMap<String, String>();
            rules.put("*", "%2A");
            rules.put("+", "%20");
            rules.put("%7E", "~");
            ENCODING_RULES = Collections.unmodifiableMap(rules);
        }

        OAuthEncoder() {
        }

        public static String encode(String plain) throws UnsupportedEncodingException {
            String encoded = URLEncoder.encode(plain, BLAuthSigner.CHARSET);
            for (Map.Entry<String, String> rule : ENCODING_RULES.entrySet()) {
                encoded = encoded.replaceAll(Pattern.quote(rule.getKey()), rule.getValue());
            }
            return encoded;
        }
    }

    static class Timer {
        private final Random rand = new Random();

        Timer() {
        }

        Long getMilis() {
            return System.currentTimeMillis();
        }

        Integer getRandomInteger() {
            return this.rand.nextInt();
        }
    }
}

