/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.demo.defs;

import de.mn77.base.data.group.Group4;
import de.mn77.base.event.Procedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.jaymo_lang.edit.button.GradientButton;
import org.jaymo_lang.edit.defs.TextOutput;
import org.jaymo_lang.edit.defs.TextResult;
import org.jaymo_lang.edit.editor.CodeEditor;

public class DemoMainPanel
extends JPanel {
    private static final long serialVersionUID = 6516457542639499873L;
    public static final Font FONT = new Font("DialogInput", 0, 15);
    public static final int FONT_CHAR_WIDTH = 9;
    public static final int FONT_LINE_HEIGHT = 18;
    private final Consumer<Group4<String, JTextArea, JTextField, Procedure>> proc;
    private final Procedure reset;
    private final CodeEditor compCode = new CodeEditor(9, 18);
    private final TextOutput compOutput = new TextOutput();
    private final TextResult compResult = new TextResult();
    private final JButton buttonExec = new JButton("Execute");
    private final JButton buttonClear = new GradientButton("Clear", new Color(127, 255, 127));
    private final JButton buttonReset = new GradientButton("Reset", new Color(255, 143, 143));

    public DemoMainPanel(Consumer<Group4<String, JTextArea, JTextField, Procedure>> proc, Procedure reset) {
        super(new FlowLayout());
        this.proc = proc;
        this.reset = reset;
        this.compCode.setFont(FONT);
        this.compOutput.setFont(FONT);
        this.compResult.setFont(FONT);
        this.buttonReset.setBackground(new Color(255, 143, 143));
        this.buttonExec.setToolTipText("Ctrl + Enter");
        JScrollPane scroll1 = new JScrollPane(this.compCode);
        JScrollPane scroll2 = new JScrollPane(this.compOutput);
        scroll1.getViewport().setBackground(Color.white);
        scroll1.setOpaque(true);
        this.initEvents();
        JPanel left = new JPanel();
        SpringLayout leftLayout = new SpringLayout();
        left.setLayout(leftLayout);
        left.add(scroll1);
        left.add(this.buttonExec);
        left.add(this.buttonClear);
        left.add(this.buttonReset);
        leftLayout.putConstraint("East", (Component)this.buttonReset, -5, "East", (Component)left);
        leftLayout.putConstraint("South", (Component)this.buttonReset, -5, "South", (Component)left);
        this.buttonReset.setPreferredSize(new Dimension(75, 30));
        leftLayout.putConstraint("East", (Component)this.buttonClear, -5, "West", (Component)this.buttonReset);
        leftLayout.putConstraint("South", (Component)this.buttonClear, -5, "South", (Component)left);
        this.buttonClear.setPreferredSize(new Dimension(75, 30));
        leftLayout.putConstraint("West", (Component)this.buttonExec, 5, "West", (Component)left);
        leftLayout.putConstraint("East", (Component)this.buttonExec, -5, "West", (Component)this.buttonClear);
        leftLayout.putConstraint("South", (Component)this.buttonExec, -5, "South", (Component)left);
        this.buttonExec.setPreferredSize(new Dimension(200, 30));
        leftLayout.putConstraint("West", (Component)scroll1, 5, "West", (Component)left);
        leftLayout.putConstraint("North", (Component)scroll1, 5, "North", (Component)left);
        leftLayout.putConstraint("East", (Component)scroll1, -5, "East", (Component)left);
        leftLayout.putConstraint("South", (Component)scroll1, -5, "North", (Component)this.buttonExec);
        JPanel right = new JPanel();
        SpringLayout rightLayout = new SpringLayout();
        right.setLayout(rightLayout);
        right.add(scroll2);
        right.add(this.compResult);
        rightLayout.putConstraint("West", (Component)this.compResult, 5, "West", (Component)right);
        rightLayout.putConstraint("East", (Component)this.compResult, -5, "East", (Component)right);
        rightLayout.putConstraint("South", (Component)this.compResult, -5, "South", (Component)right);
        rightLayout.putConstraint("West", (Component)scroll2, 5, "West", (Component)right);
        rightLayout.putConstraint("North", (Component)scroll2, 5, "North", (Component)right);
        rightLayout.putConstraint("East", (Component)scroll2, -5, "East", (Component)right);
        rightLayout.putConstraint("South", (Component)scroll2, -5, "North", (Component)this.compResult);
        DemoMainPanel panel3 = this;
        GridLayout layout2 = new GridLayout();
        layout2.setColumns(2);
        layout2.setRows(1);
        panel3.setLayout(layout2);
        panel3.add(left);
        panel3.add(right);
    }

    private void initEvents() {
        this.buttonExec.addActionListener(event -> {
            this.compOutput.setText("");
            this.compResult.setText("");
            this.execute();
        });
        this.buttonReset.addActionListener(event -> {
            this.reset.execute();
            this.buttonExec.setEnabled(true);
        });
        this.buttonClear.addActionListener(event -> {
            this.compCode.setText("");
            this.compOutput.setText("");
            this.compResult.setText("");
        });
    }

    public void execute() {
        if (!this.buttonExec.isEnabled()) {
            return;
        }
        String source = this.compCode.getText();
        this.buttonExec.setEnabled(false);
        Procedure onFinish = () -> this.buttonExec.setEnabled(true);
        this.proc.accept(new Group4<String, TextOutput, TextResult, Procedure>(source, this.compOutput, this.compResult, onFinish));
    }
}

