/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.tcp;

import de.mn77.base.error.Err;
import de.mn77.base.event.A_EnumEventHandler;
import de.mn77.lib.tcp.TCP_Connection;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.function.Consumer;

public class TCP_Client
extends A_EnumEventHandler {
    private static final int DEFAULT_TIMEOUT = 30000;
    private final String host;
    private final int port;

    public TCP_Client(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
    }

    public TCP_Connection connect() {
        try {
            Socket socket = new Socket(this.host, this.port);
            socket.setSoTimeout(30000);
            return new TCP_Connection(socket, false);
        }
        catch (ConnectException e) {
            Err.show(e);
            this.eventStart(EVENTS.ERROR, e);
        }
        catch (SocketTimeoutException e) {
            Err.show(e);
            this.eventStart(EVENTS.TIMEOUT, e);
        }
        catch (UnknownHostException e) {
            Err.show(e);
            this.eventStart(EVENTS.ERROR, e);
        }
        catch (IOException e) {
            Err.show(e);
            this.eventStart(EVENTS.ERROR, e);
        }
        return null;
    }

    public void onTimeOut(Consumer<SocketTimeoutException> z) {
        this.eventAdd(EVENTS.TIMEOUT, z);
    }

    public void onError(Consumer<IOException> z) {
        this.eventAdd(EVENTS.ERROR, z);
    }

    private static enum EVENTS {
        TIMEOUT,
        ERROR;

    }
}

