/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.Event;
import opennlp.model.MaxentModel;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;
import opennlp.tools.util.CollectionEventStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNonReferentialResolver
implements NonReferentialResolver {
    private MaxentModel model;
    private List<Event> events;
    private boolean loadAsResource;
    private boolean debugOn = false;
    private ResolverMode mode;
    private String modelName;
    private String modelExtension = ".bin.gz";
    private int nonRefIndex;

    public DefaultNonReferentialResolver(String projectName, String name, ResolverMode mode) throws IOException {
        this.mode = mode;
        this.modelName = projectName + "/" + name + ".nr";
        if (mode == ResolverMode.TRAIN) {
            this.events = new ArrayList<Event>();
        } else if (mode == ResolverMode.TEST) {
            this.model = this.loadAsResource ? new BinaryGISModelReader(new DataInputStream(this.getClass().getResourceAsStream(this.modelName))).getModel() : new SuffixSensitiveGISModelReader(new File(this.modelName + this.modelExtension)).getModel();
            this.nonRefIndex = this.model.getIndex("same");
        } else {
            throw new RuntimeException("unexpected mode " + (Object)((Object)mode));
        }
    }

    @Override
    public double getNonReferentialProbability(MentionContext mention) {
        List<String> features = this.getFeatures(mention);
        double r = this.model.eval(features.toArray(new String[features.size()]))[this.nonRefIndex];
        if (this.debugOn) {
            System.err.println(this + " " + mention.toText() + " ->  null " + r + " " + features);
        }
        return r;
    }

    @Override
    public void addEvent(MentionContext ec) {
        List<String> features = this.getFeatures(ec);
        if (-1 == ec.getId()) {
            this.events.add(new Event("same", features.toArray(new String[features.size()])));
        } else {
            this.events.add(new Event("diff", features.toArray(new String[features.size()])));
        }
    }

    protected List<String> getFeatures(MentionContext mention) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("default");
        features.addAll(this.getNonReferentialFeatures(mention));
        return features;
    }

    protected List<String> getNonReferentialFeatures(MentionContext mention) {
        ArrayList<String> features = new ArrayList<String>();
        Parse[] mtokens = mention.getTokenParses();
        for (int ti = 0; ti <= mention.getHeadTokenIndex(); ++ti) {
            Parse tok = mtokens[ti];
            List<String> wfs = ResolverUtils.getWordFeatures(tok);
            for (int wfi = 0; wfi < wfs.size(); ++wfi) {
                features.add("nr" + wfs.get(wfi));
            }
        }
        features.addAll(ResolverUtils.getContextFeatures(mention));
        return features;
    }

    @Override
    public void train() throws IOException {
        if (ResolverMode.TRAIN == this.mode) {
            System.err.println(this + " referential");
            if (this.debugOn) {
                FileWriter writer = new FileWriter(this.modelName + ".events");
                for (Event e : this.events) {
                    writer.write(e.toString() + "\n");
                }
                writer.close();
            }
            new SuffixSensitiveGISModelWriter(GIS.trainModel(new CollectionEventStream(this.events), 100, 10), new File(this.modelName + this.modelExtension)).persist();
        }
    }
}

