/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.FeatureFileReader;
import marytts.util.data.MaryHeader;

public class VocalizationFeatureFileReader
extends FeatureFileReader {
    public VocalizationFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    @Override
    protected void loadFromStream(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 325) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary listener feature file.");
        }
        this.featureDefinition = new FeatureDefinition(dis);
        int numberOfUnits = dis.readInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        int i = 0;
        while (i < numberOfUnits) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, dis);
            ++i;
        }
    }

    @Override
    protected void loadFromByteBuffer(String fileName) throws IOException, MaryConfigurationException {
        FileInputStream fis = new FileInputStream(fileName);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        fis.close();
        this.hdr = new MaryHeader(bb);
        if (this.hdr.getType() != 325) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary listener feature file.");
        }
        this.featureDefinition = new FeatureDefinition(bb);
        int numberOfUnits = bb.getInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        int i = 0;
        while (i < numberOfUnits) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, bb);
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

