/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.signalproc.adaptation.prosody.PitchMapping;
import marytts.signalproc.adaptation.prosody.PitchMappingFileHeader;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchStatisticsCollection;
import marytts.util.io.FileUtils;
import marytts.util.io.MaryRandomAccessFile;

public class PitchMappingFile {
    int status;
    public static int NOT_OPENED = -1;
    public static int OPEN_FOR_READ = 0;
    public static int OPEN_FOR_WRITE = 1;
    public MaryRandomAccessFile stream;
    public String currentFile;
    public static String DEFAULT_EXTENSION = ".pmf";

    public PitchMappingFile() {
        this("");
    }

    public PitchMappingFile(String pitchMappingFile) {
        this(pitchMappingFile, NOT_OPENED);
    }

    public PitchMappingFile(String pitchMappingFile, int desiredStatus) {
        this.init(pitchMappingFile, desiredStatus);
    }

    private void init(String pitchMappingFile, int desiredStatus) {
        this.status = NOT_OPENED;
        this.stream = null;
        this.currentFile = "";
        if (desiredStatus == OPEN_FOR_READ) {
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(pitchMappingFile, "r");
                this.currentFile = pitchMappingFile;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (desiredStatus == OPEN_FOR_WRITE) {
            FileUtils.delete(pitchMappingFile);
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(pitchMappingFile, "rw");
                this.currentFile = pitchMappingFile;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.status != NOT_OPENED) {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.stream = null;
            this.status = NOT_OPENED;
        }
    }

    public PitchMappingFileHeader readPitchMappingHeader(String pitchMappingFile, boolean bCloseAfterReading) {
        this.init(pitchMappingFile, OPEN_FOR_READ);
        return this.readPitchMappingHeader();
    }

    public PitchMappingFileHeader readPitchMappingHeader() {
        try {
            return PitchMappingFile.readPitchMappingHeader(this.stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PitchMappingFileHeader readPitchMappingHeader(MaryRandomAccessFile ler) throws IOException {
        PitchMappingFileHeader header = new PitchMappingFileHeader();
        header.read(ler);
        return header;
    }

    public MaryRandomAccessFile writePitchMappingHeader(String pitchMappingFile, PitchMappingFileHeader header) {
        this.init(pitchMappingFile, OPEN_FOR_WRITE);
        return this.writePitchMappingHeader(header);
    }

    public MaryRandomAccessFile writePitchMappingHeader(PitchMappingFileHeader header) {
        try {
            this.writePitchMappingHeader(this.stream, header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stream;
    }

    public void writePitchMappingHeader(MaryRandomAccessFile ler, PitchMappingFileHeader header) throws IOException {
        header.write(ler);
    }

    public PitchMapping readPitchMappingFile() throws IOException {
        return this.readPitchMappingFile(this.currentFile);
    }

    public PitchMapping readPitchMappingFile(String pitchMappingFile) throws IOException {
        PitchMapping pitchMapping = null;
        if (FileUtils.exists(pitchMappingFile)) {
            if (this.status != OPEN_FOR_READ) {
                if (this.status != NOT_OPENED) {
                    this.close();
                }
                this.init(pitchMappingFile, OPEN_FOR_READ);
            }
            if (this.status == OPEN_FOR_READ) {
                pitchMapping = new PitchMapping();
                pitchMapping.header = this.readPitchMappingHeader();
                this.readPitchMappingFileExcludingHeader(pitchMapping);
            }
        }
        return pitchMapping;
    }

    public void readPitchMappingFileExcludingHeader(PitchMapping pitchMapping) {
        pitchMapping.allocate();
        System.out.println("Reading pitch mapping file: " + this.currentFile + "...");
        pitchMapping.f0StatisticsCollection = new PitchStatisticsCollection(pitchMapping.header.totalF0StatisticsEntries);
        int i = 0;
        while (i < pitchMapping.header.totalF0StatisticsEntries) {
            pitchMapping.f0StatisticsCollection.entries[i] = this.readF0StatisticsEntry();
            ++i;
        }
        pitchMapping.setF0StatisticsMapping();
        this.close();
        System.out.println("Reading completed...");
    }

    public void WriteCodebookFile(String pitchMappingFile, PitchMapping pitchMapping) {
        if (this.status != OPEN_FOR_WRITE) {
            if (this.status != NOT_OPENED) {
                this.close();
            }
            this.init(pitchMappingFile, OPEN_FOR_WRITE);
        }
        pitchMapping.header.totalF0StatisticsEntries = pitchMapping.f0StatisticsCollection.entries.length;
        this.writePitchMappingHeader(pitchMappingFile, pitchMapping.header);
        int i = 0;
        while (i < pitchMapping.header.totalF0StatisticsEntries) {
            this.writeF0StatisticsEntry(pitchMapping.f0StatisticsCollection.entries[i]);
            ++i;
        }
        this.close();
    }

    public void writeF0StatisticsEntry(PitchStatistics p) {
        if (this.status == OPEN_FOR_WRITE) {
            p.write(this.stream);
            this.incrementTotalF0StatisticsEntries();
        }
    }

    public PitchStatistics readF0StatisticsEntry() {
        PitchStatistics p = new PitchStatistics();
        if (this.status == OPEN_FOR_READ) {
            p.read(this.stream);
        }
        return p;
    }

    public void incrementTotalF0StatisticsEntries() {
        if (this.status == OPEN_FOR_WRITE) {
            try {
                long currentPos = this.stream.getFilePointer();
                this.stream.seek(0L);
                int totalF0StatisticsEntries = this.stream.readInt();
                this.stream.seek(0L);
                this.stream.writeInt(++totalF0StatisticsEntries);
                System.out.println("Wrote f0 statistics entry " + String.valueOf(totalF0StatisticsEntries));
                this.stream.seek(currentPos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

