/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Zmat;
import Jampack.Zutmat;

public class Zchol {
    public int n;
    public Zutmat R;

    public Zchol(Zmat A) throws JampackException {
        int j;
        int i;
        A.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Matrix not square.");
        }
        this.n = A.nr;
        this.R = new Zutmat(A);
        for (i = 0; i < this.n; ++i) {
            if (this.R.im[i][i] != 0.0) {
                throw new JampackException("Matrix not Hermitian");
            }
            for (j = 0; j < i; ++j) {
                if (this.R.re[i][j] != this.R.re[j][i] || this.R.im[i][j] != -this.R.im[j][i]) {
                    throw new JampackException("Matrix not Hermitian");
                }
                this.R.im[i][j] = 0.0;
                this.R.re[i][j] = 0.0;
            }
        }
        for (int k = 0; k < this.n; ++k) {
            if (this.R.re[k][k] <= 0.0) {
                throw new JampackException("Nonpositive diagonal entry during reduction.");
            }
            this.R.re[k][k] = Math.sqrt(this.R.re[k][k]);
            double mu = 1.0 / this.R.re[k][k];
            for (j = k + 1; j < this.n; ++j) {
                this.R.re[k][j] = mu * this.R.re[k][j];
                this.R.im[k][j] = mu * this.R.im[k][j];
            }
            for (i = k + 1; i < this.n; ++i) {
                for (j = i; j < this.n; ++j) {
                    this.R.re[i][j] = this.R.re[i][j] - this.R.re[k][i] * this.R.re[k][j] - this.R.im[k][i] * this.R.im[k][j];
                    this.R.im[i][j] = this.R.im[i][j] - this.R.re[k][i] * this.R.im[k][j] + this.R.im[k][i] * this.R.re[k][j];
                }
                this.R.im[i][i] = 0.0;
            }
        }
    }
}

