/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import java.awt.Color;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.ext.pdf.create.Lib_PDFC_Tools;
import org.jaymo_lang.ext.pdf.create.PDFC_Calculator;
import org.jaymo_lang.ext.pdf.create.constant.JMo_PDFC_Font;
import org.jaymo_lang.ext.pdf.create.page.I_PDFC_PageData;
import org.jaymo_lang.ext.pdf.create.page.item.I_PDFC_PageItem;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_PDFC_ItemText
extends A_ObjectSimple
implements I_PDFC_PageItem {
    private POSITION_H alignment;
    private boolean bold;
    private boolean italic;
    private JMo_PDFC_Font font;
    private int fontsize;
    private int[] rgb;
    private final String text;
    private final float x;
    private final float y;

    public JMo_PDFC_ItemText(float x, float y, String text, String defaultFont, Integer defaultFontSize, int[] defaultColorFont, POSITION_H defaultFontAlign) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.font = new JMo_PDFC_Font();
        this.fontsize = defaultFontSize != null ? defaultFontSize : 12;
        this.rgb = defaultColorFont != null ? defaultColorFont : new int[3];
        this.alignment = defaultFontAlign != null ? defaultFontAlign : POSITION_H.LEFT;
        this.bold = false;
        this.italic = false;
    }

    @Override
    public void draw(I_PDFC_PageData page, PdfContentByte cb, PDFC_Calculator calc, DebugInfo debug) {
        cb.setColorFill(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
        cb.beginText();
        cb.setFontAndSize(this.font.getBaseFont(this.bold, this.italic, debug), (float)this.fontsize);
        int align = 0;
        if (this.alignment == POSITION.RIGHT) {
            align = 2;
        }
        if (this.alignment == POSITION.CENTER) {
            align = 1;
        }
        cb.showTextAligned(align, this.text, calc.x(this.x), calc.y(page, this.y), 0.0f);
        cb.endText();
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setColor": {
                return this.mSetColor(cr);
            }
            case "setAlignment": 
            case "setAlign": {
                return this.mSetAlignment(cr);
            }
            case "alignLeft": {
                return this.mAlignLeft(cr);
            }
            case "alignCenter": {
                return this.mAlignCenter(cr);
            }
            case "alignRight": {
                return this.mAlignRight(cr);
            }
            case "bold": {
                return this.mBold(cr);
            }
            case "italic": {
                return this.mItalic(cr);
            }
            case "setFontSize": 
            case "setFontsize": {
                return this.mSetFontsize(cr);
            }
            case "setFont": {
                return this.mSetFont(cr);
            }
        }
        return null;
    }

    private JMo_PDFC_ItemText mAlignCenter(CallRuntime cr) {
        cr.argsNone();
        this.alignment = POSITION_H.CENTER;
        return this;
    }

    private JMo_PDFC_ItemText mAlignLeft(CallRuntime cr) {
        cr.argsNone();
        this.alignment = POSITION_H.LEFT;
        return this;
    }

    private JMo_PDFC_ItemText mAlignRight(CallRuntime cr) {
        cr.argsNone();
        this.alignment = POSITION_H.RIGHT;
        return this;
    }

    private JMo_PDFC_ItemText mBold(CallRuntime cr) {
        cr.argsNone();
        this.bold = true;
        return this;
    }

    private JMo_PDFC_ItemText mItalic(CallRuntime cr) {
        cr.argsNone();
        this.italic = true;
        return this;
    }

    private JMo_PDFC_ItemText mSetAlignment(CallRuntime cr) {
        MagicPosition arg = (MagicPosition)cr.args((I_Object)this, new Class[]{MagicPosition.class})[0];
        POSITION pos = arg.get();
        if (!Lib_Position.isHorizontal((POSITION)pos)) {
            throw new ExecError(cr, "Invalid position", "Allowed are only horizontal positions");
        }
        this.alignment = Lib_Position.getHorizontal((POSITION)pos);
        return this;
    }

    private JMo_PDFC_ItemText mSetColor(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.rgb = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_ItemText mSetFont(CallRuntime cr) {
        this.font = (JMo_PDFC_Font)cr.args((I_Object)this, new Class[]{JMo_PDFC_Font.class})[0];
        return this;
    }

    private JMo_PDFC_ItemText mSetFontsize(CallRuntime cr) {
        Int arg = (Int)cr.args((I_Object)this, new Class[]{Int.class})[0];
        int i = Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (int)4, (int)150, (int)this.fontsize, (String)"Fontsize");
        this.fontsize = i;
        return this;
    }
}

