/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.ext.pdf.create.Lib_PDFC_Tools;
import org.jaymo_lang.ext.pdf.create.PDFC_Calculator;
import org.jaymo_lang.ext.pdf.create.page.I_PDFC_PageData;
import org.jaymo_lang.ext.pdf.create.page.item.I_PDFC_PageItem;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_PDFC_ItemLine
extends A_ObjectSimple
implements I_PDFC_PageItem {
    private int[] colorRGB;
    private Float thickness = null;
    private final float x1;
    private final float x2;
    private final float y1;
    private final float y2;

    public JMo_PDFC_ItemLine(float x1, float y1, float x2, float y2, Float defaultLineThickness, int[] defaultColorLine) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.thickness = defaultLineThickness;
        this.colorRGB = defaultColorLine != null ? defaultColorLine : new int[3];
    }

    @Override
    public void draw(I_PDFC_PageData page, PdfContentByte cb, PDFC_Calculator calc, DebugInfo debug) {
        if (this.thickness == null) {
            this.thickness = calc.reverse(1);
        }
        cb.setColorStroke(new Color(this.colorRGB[0], this.colorRGB[1], this.colorRGB[2]));
        cb.setLineWidth(calc.o(this.thickness.floatValue()));
        cb.moveTo(calc.x(this.x1), calc.y(page, this.y1));
        cb.lineTo(calc.x(this.x2), calc.y(page, this.y2));
        cb.stroke();
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setThickness": {
                return this.mSetThickness(cr);
            }
            case "setColor": {
                return this.mSetColor(cr);
            }
        }
        return null;
    }

    private JMo_PDFC_ItemLine mSetColor(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.colorRGB = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_ItemLine mSetThickness(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Dec.class})[0];
        float f = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (double)0.0, (double)50.0, (double)f, (String)"thickness");
        this.thickness = Float.valueOf(f);
        return this;
    }
}

