/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.ext.pdf.create.Lib_PDFC_Tools;
import org.jaymo_lang.ext.pdf.create.PDFC_Calculator;
import org.jaymo_lang.ext.pdf.create.page.I_PDFC_PageData;
import org.jaymo_lang.ext.pdf.create.page.item.I_PDFC_PageItem;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_PDFC_ItemCircle
extends A_ObjectSimple
implements I_PDFC_PageItem {
    private int[] colorFill;
    private int[] colorBorder;
    private boolean drawFilling;
    private boolean drawBorder;
    private Float thickness = null;
    private final float x;
    private final float y;
    private final float r;

    public JMo_PDFC_ItemCircle(float x, float y, float r, Float defaultLineThickness, int[] defaultColorBorder, int[] defaultColorFill) {
        this.x = x;
        this.y = y;
        this.r = r;
        this.thickness = defaultLineThickness;
        this.colorBorder = defaultColorBorder != null ? defaultColorBorder : new int[3];
        this.colorFill = defaultColorFill != null ? defaultColorFill : new int[3];
        this.drawFilling = false;
        this.drawBorder = true;
    }

    @Override
    public void draw(I_PDFC_PageData page, PdfContentByte cb, PDFC_Calculator calc, DebugInfo debug) {
        if (this.thickness == null) {
            this.thickness = calc.reverse(1);
        }
        if (this.drawFilling) {
            cb.setColorFill(new Color(this.colorFill[0], this.colorFill[1], this.colorFill[2]));
            cb.circle(calc.x(this.x), calc.y(page, this.y), calc.o(this.r));
            cb.fill();
            cb.stroke();
        }
        if (this.drawBorder) {
            cb.setColorStroke(new Color(this.colorBorder[0], this.colorBorder[1], this.colorBorder[2]));
            cb.setLineWidth(calc.o(this.thickness.floatValue()));
            cb.circle(calc.x(this.x), calc.y(page, this.y), calc.o(this.r));
            cb.stroke();
        }
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setStyle": {
                return this.mSetStyle(cr);
            }
            case "setThickness": {
                return this.mSetThickness(cr);
            }
            case "setColorFill": 
            case "setFillColor": {
                return this.mSetFillColor(cr);
            }
            case "setColorBorder": 
            case "setBorderColor": {
                return this.mSetBorderColor(cr);
            }
        }
        return null;
    }

    private JMo_PDFC_ItemCircle mSetBorderColor(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.colorBorder = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_ItemCircle mSetFillColor(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.colorFill = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_ItemCircle mSetStyle(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Bool.class, Bool.class});
        boolean drawFilling = Lib_Convert.getBoolValue((CallRuntime)cr, (I_Object)args[0]);
        boolean drawBorder = Lib_Convert.getBoolValue((CallRuntime)cr, (I_Object)args[1]);
        if (!drawFilling && !drawBorder) {
            throw new ExecError(cr, "Invalid arguments", "A circle without filling and border will not be drawed!");
        }
        this.drawFilling = drawFilling;
        this.drawBorder = drawBorder;
        return this;
    }

    private JMo_PDFC_ItemCircle mSetThickness(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Dec.class})[0];
        float f = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (double)0.0, (double)50.0, (double)f, (String)"thickness");
        this.thickness = Float.valueOf(f);
        return this;
    }
}

