/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.page;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.lib.graphic.I_Image;
import java.util.ArrayList;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.ext.pdf.create.I_PDFC_BaseItem;
import org.jaymo_lang.ext.pdf.create.Lib_PDFC_Tools;
import org.jaymo_lang.ext.pdf.create.PDFC_Calculator;
import org.jaymo_lang.ext.pdf.create.constant.JMo_PDFC_PageSize;
import org.jaymo_lang.ext.pdf.create.page.I_PDFC_PageData;
import org.jaymo_lang.ext.pdf.create.page.item.I_PDFC_PageItem;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_PDFC_ItemCircle;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_PDFC_ItemImage;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_PDFC_ItemLine;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_PDFC_ItemRectangle;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_PDFC_ItemText;
import org.jaymo_lang.lib.graphic.JMo_Image;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_PDFC_Page
extends A_ObjectSimple
implements I_PDFC_BaseItem,
I_PDFC_PageData {
    private int[] defaultColorLine = null;
    private int[] defaultColorFont = null;
    private int[] defaultColorFill = null;
    private String defaultFont;
    private POSITION_H defaultFontAlign;
    private Integer defaultFontSize = null;
    private Float defaultLineThickness = null;
    private Rectangle format;
    private boolean isLandscape = false;
    private final ArrayList<I_PDFC_PageItem> items = new ArrayList();
    private final PDFC_Calculator calc;

    public JMo_PDFC_Page(PDFC_Calculator calc) {
        this.format = JMo_PDFC_PageSize.DEFAULT;
        this.calc = calc;
    }

    public void draw(PdfContentByte cb, DebugInfo debug) {
        Rectangle rect = this.format;
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        for (I_PDFC_PageItem e : this.items) {
            e.draw(this, cb, this.calc, debug);
        }
    }

    @Override
    public Rectangle getFormat() {
        return this.format;
    }

    @Override
    public float getHeight() {
        Rectangle format = this.format;
        if (this.isLandscape) {
            format = format.rotate();
        }
        return format.getHeight();
    }

    @Override
    public float getWidth() {
        Rectangle rect = this.format;
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        return rect.getWidth();
    }

    @Override
    public boolean isLandscape() {
        return this.isLandscape;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "newRectangle": {
                return this.mNewRectangle(cr);
            }
            case "newLine": {
                return this.mNewLine(cr);
            }
            case "newText": {
                return this.mNewText(cr);
            }
            case "newCircle": {
                return this.mNewCircle(cr);
            }
            case "newImage": {
                return this.mNewImage(cr);
            }
            case "getWidth": {
                return this.mGetWidth(cr);
            }
            case "getHeight": {
                return this.mGetHeight(cr);
            }
            case "setFormat": {
                return this.mSetFormat(cr);
            }
            case "setOrientation": {
                return this.mSetOrientation(cr);
            }
            case "setDefaultFont": {
                return this.mSetDefaultFont(cr);
            }
            case "setDefaultFontSize": 
            case "setDefaultFontsize": {
                return this.mSetDefaultFontSize(cr);
            }
            case "setDefaultThickness": {
                return this.mSetDefaultThickness(cr);
            }
            case "setDefaultColorFont": 
            case "setDefaultFontColor": {
                return this.mSetDefaultColorFont(cr);
            }
            case "setDefaultFontAlign": {
                return this.mSetDefaultFontAlign(cr);
            }
            case "setDefaultColorLine": 
            case "setDefaultLineColor": {
                return this.mSetDefaultColorLine(cr);
            }
            case "setDefaultColorFill": 
            case "setDefaultFillColor": {
                return this.mSetDefaultColorFill(cr);
            }
        }
        return null;
    }

    private Dec mGetHeight(CallRuntime cr) {
        cr.argsNone();
        float d = this.getHeight();
        d = this.calc.width(d);
        return new Dec((double)d);
    }

    private Dec mGetWidth(CallRuntime cr) {
        cr.argsNone();
        float d = this.getWidth();
        d = this.calc.width(d);
        return new Dec((double)d);
    }

    private JMo_PDFC_ItemCircle mNewCircle(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Dec.class, Dec.class, Dec.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float r = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        JMo_PDFC_ItemCircle result = new JMo_PDFC_ItemCircle(x, y, r, this.defaultLineThickness, this.defaultColorLine, this.defaultColorFill);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_ItemImage mNewImage(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 3, 5);
        Lib_Error.ifIs((CallRuntime)cr, (int)4, (int)args.length, (String)"amount of arguments");
        boolean has5Args = args.length == 5;
        JMo_Image image = (JMo_Image)cr.argType(args[0], JMo_Image.class);
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)cr.argType(args[1], Dec.class));
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)cr.argType(args[2], Dec.class));
        int dx = has5Args ? Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)cr.argType(args[3], Dec.class)) : image.internalGet().getWidth();
        int dy = has5Args ? Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)cr.argType(args[4], Dec.class)) : image.internalGet().getHeight();
        JMo_PDFC_ItemImage result = new JMo_PDFC_ItemImage((I_Image)image.internalGet(), x, y, dx, dy);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_ItemLine mNewLine(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Dec.class, Dec.class, Dec.class, Dec.class});
        float x1 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y1 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float x2 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        float y2 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[3]);
        JMo_PDFC_ItemLine result = new JMo_PDFC_ItemLine(x1, y1, x2, y2, this.defaultLineThickness, this.defaultColorLine);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_ItemRectangle mNewRectangle(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Dec.class, Dec.class, Dec.class, Dec.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float dx = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        float dy = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[3]);
        JMo_PDFC_ItemRectangle result = new JMo_PDFC_ItemRectangle(x, y, dx, dy, this.defaultLineThickness, this.defaultColorLine, this.defaultColorFill);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_ItemText mNewText(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Dec.class, Dec.class, Str.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)args[2]);
        JMo_PDFC_ItemText result = new JMo_PDFC_ItemText(x, y, text, this.defaultFont, this.defaultFontSize, this.defaultColorFont, this.defaultFontAlign);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_Page mSetDefaultColorFill(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorFill = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_Page mSetDefaultColorFont(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorFont = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_Page mSetDefaultColorLine(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorLine = Lib_PDFC_Tools.argsColorToArray(cr, args);
        return this;
    }

    private JMo_PDFC_Page mSetDefaultFontAlign(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{MagicPosition.class})[0];
        POSITION pos = ((MagicPosition)arg).get();
        if (!Lib_Position.isHorizontal((POSITION)pos)) {
            throw new ExecError(cr, "Invalid alignment", "Text alignment must be left, center or right!");
        }
        this.defaultFontAlign = (POSITION_H)pos;
        return this;
    }

    private JMo_PDFC_Page mSetDefaultThickness(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Dec.class})[0];
        double d = Lib_Convert.getDoubleValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (double)0.1, (double)20.0, (double)d, (String)"thickness");
        this.defaultLineThickness = Float.valueOf((float)d);
        return this;
    }

    private JMo_PDFC_Page mSetDefaultFont(CallRuntime cr) {
        String fontname;
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        this.defaultFont = fontname = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
        return this;
    }

    private JMo_PDFC_Page mSetDefaultFontSize(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Int.class})[0];
        int size = Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (int)4, (int)100, (int)size, (String)"fontsize");
        this.defaultFontSize = size;
        return this;
    }

    private JMo_PDFC_Page mSetFormat(CallRuntime cr) {
        JMo_PDFC_PageSize format = (JMo_PDFC_PageSize)cr.args((I_Object)this, new Class[]{JMo_PDFC_PageSize.class})[0];
        this.format = format.getRectangle();
        return this;
    }

    private JMo_PDFC_Page mSetOrientation(CallRuntime cr) {
        boolean value;
        I_Object arg = cr.args((I_Object)this, new Class[]{Bool.class})[0];
        this.isLandscape = value = Lib_Convert.getBoolValue((CallRuntime)cr, (I_Object)arg);
        return this;
    }
}

