/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.error.Err;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.ext.pdf.create.I_PDFC_BaseItem;
import org.jaymo_lang.ext.pdf.create.PDFC_Calculator;
import org.jaymo_lang.ext.pdf.create.page.JMo_PDFC_Page;
import org.jaymo_lang.ext.pdf.create.text.I_PDFC_TextItem;
import org.jaymo_lang.ext.pdf.create.text.JMo_PDFC_TextChunk;
import org.jaymo_lang.ext.pdf.create.text.JMo_PDFC_TextParagraph;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_PDFC_Document
extends A_ObjectSimple {
    private final ArrayList<I_PDFC_BaseItem> items = new ArrayList();
    private final PDFC_Calculator calc = new PDFC_Calculator();

    public A_Immutable getConstant(CallRuntime cr, String name) {
        switch (name) {
            case "ZOLL": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "ORIGINAL": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "CM": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "MM": {
                return new JMo_Enum(this.getTypeName(), name);
            }
        }
        return null;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "newPage": {
                return this.mNewPage(cr);
            }
            case "newParagraph": {
                return this.mNewParagraph(cr);
            }
            case "newTextChunk": 
            case "newText": {
                return this.mNewTextChunk(cr);
            }
            case "write": {
                this.mWrite(cr);
                return this;
            }
            case "setAnchor": {
                this.mSetAnchor(cr);
                return this;
            }
            case "setMetrics": {
                this.mSetMetrics(cr);
                return this;
            }
        }
        return null;
    }

    private void mSetMetrics(CallRuntime cr) {
        JMo_Enum arg = cr.argEnum((I_Object)this);
        this.calc.setMetrics(arg);
    }

    private void mSetAnchor(CallRuntime cr) {
        MagicPosition arg = (MagicPosition)cr.args((I_Object)this, new Class[]{MagicPosition.class})[0];
        POSITION p = arg.get();
        if (p != POSITION.TOP_LEFT && p != POSITION.BOTTOM_LEFT) {
            throw new ExecError(cr, "Invalid achor", "Anchor must be Top-Left or Bottom-Left, but is: " + p.toString());
        }
        this.calc.setAnchor(p == POSITION.TOP_LEFT);
    }

    private JMo_PDFC_Page mNewPage(CallRuntime cr) {
        cr.argsNone();
        JMo_PDFC_Page result = new JMo_PDFC_Page(this.calc);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_TextChunk mNewTextChunk(CallRuntime cr) {
        I_Object arg0 = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg0);
        JMo_PDFC_TextChunk result = new JMo_PDFC_TextChunk(text);
        this.items.add(result);
        return result;
    }

    private JMo_PDFC_TextParagraph mNewParagraph(CallRuntime cr) {
        I_Object arg0 = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg0);
        JMo_PDFC_TextParagraph result = new JMo_PDFC_TextParagraph(text);
        this.items.add(result);
        return result;
    }

    private void mWrite(CallRuntime cr) {
        I_Object arg = cr.argsExt((I_Object)this, (Class[][])new Class[][]{{JMo_File.class, Str.class}})[0];
        if (arg instanceof Str) {
            String file = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
            try {
                FileOutputStream stream = new FileOutputStream(file);
                this.iWrite(stream, cr.getDebugInfo());
            }
            catch (FileNotFoundException e) {
                throw new ExecError(cr, "PDF write error", "Could not write to file: " + file);
            }
        }
        JMo_File file = (JMo_File)arg;
        try {
            FileOutputStream stream = new FileOutputStream(file.getInternalFile());
            this.iWrite(stream, cr.getDebugInfo());
        }
        catch (FileNotFoundException e) {
            throw new ExecError(cr, "PDF write error", "Could not write to file: " + file.getInternalFile().getAbsolutePath());
        }
    }

    private void iWrite(OutputStream stream, DebugInfo debug) {
        Document document = null;
        PdfWriter writer = null;
        for (I_PDFC_BaseItem item : this.items) {
            if (item instanceof JMo_PDFC_Page) {
                JMo_PDFC_Page page = (JMo_PDFC_Page)item;
                Rectangle rect = page.getFormat();
                if (page.isLandscape()) {
                    rect = rect.rotate();
                }
                try {
                    if (document == null) {
                        document = new Document(page.getFormat());
                        writer = PdfWriter.getInstance((Document)document, (OutputStream)stream);
                        writer.setPdfVersion('2');
                        document.open();
                    } else {
                        document.setPageSize(rect);
                        document.newPage();
                        writer.setPageEmpty(false);
                    }
                    document.add((Element)new Chunk(""));
                    page.draw(writer.getDirectContent(), debug);
                    continue;
                }
                catch (DocumentException e) {
                    throw Err.direct((String)"PDF-Error", (Object[])new Object[]{e});
                }
            }
            ((I_PDFC_TextItem)item).draw(document);
        }
        document.close();
    }
}

