/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.marytts;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.ext.marytts.MaryTTS;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_MaryTTS
extends A_ObjectSimple {
    private String voice = null;
    private MaryTTS tts = null;
    private final ArgCallBuffer par_voice;

    public JMo_MaryTTS() {
        this.par_voice = null;
    }

    public JMo_MaryTTS(Call voice) {
        this.par_voice = new ArgCallBuffer(0, voice);
    }

    public void init(CallRuntime cr) {
        if (this.par_voice != null) {
            Str oa = (Str)this.par_voice.init(cr, (I_Object)this, Str.class);
            this.voice = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)oa);
        }
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "init": 
            case "start": {
                this.mStart(cr);
                return this;
            }
            case "say": {
                this.mSay(cr, true);
                return this;
            }
            case "sayAsync": {
                this.mSay(cr, false);
                return this;
            }
            case "setVoice": {
                this.mSetVoice(cr);
                return this;
            }
            case "getVoices": {
                return this.mGetVoicesTable(cr);
            }
        }
        return null;
    }

    private void mStart(CallRuntime cr) {
        cr.argsNone();
        if (this.tts != null) {
            throw new ExecError(cr, "MaryTTS allready started", "Can't start MaryTTS twice.");
        }
        this.tts = new MaryTTS();
        this.tts.startService();
    }

    private I_Object mGetVoicesTable(CallRuntime cr) {
        cr.argsNone();
        this.iCheckStarted(cr);
        I_Table<String> voices = this.tts.getVoices();
        MTable voices2 = new MTable(2);
        int z = 1;
        while (z <= voices.size()) {
            I_List zz = voices.getRow(z);
            Str l = new Str((String)zz.get(1));
            Str n = new Str((String)zz.get(2));
            voices2.add((Object[])new I_Object[]{l, n});
            ++z;
        }
        return new JMo_Table((I_Table)voices2);
    }

    private void mSetVoice(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        this.voice = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
    }

    private void mSay(CallRuntime cr, boolean wait) {
        I_Object[] oa = cr.args((I_Object)this, new Class[]{Str.class});
        this.iCheckStarted(cr);
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)oa[0]);
        if (this.voice != null) {
            this.tts.setVoiceName(this.voice);
            this.voice = null;
        }
        this.tts.textToSpeach(text, wait);
    }

    private void iCheckStarted(CallRuntime cr) {
        if (this.tts == null) {
            throw new ExecError(cr, "MaryTTS is not running!", "Please start MaryTTS first with '.start'");
        }
    }
}

