/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.db;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.ext.db.constant.DBMS;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jaymo_lang.error.ExtError;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_DBResult
extends A_ObjectSimple {
    private final DBMS dbms;
    private ResultSet resultset;
    private boolean read = false;

    public JMo_DBResult(ResultSet rs, DBMS dbms) {
        Err.ifNull((Object[])new Object[]{rs});
        this.resultset = rs;
        this.dbms = dbms;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "getObject": {
                return this.mGetObject(cr);
            }
            case "getStr": 
            case "getString": {
                return this.mGetObject(cr, ATOMIC.STR);
            }
            case "getInt": {
                return this.mGetObject(cr, ATOMIC.INT);
            }
            case "getLong": {
                return this.mGetObject(cr, ATOMIC.LONG);
            }
            case "getDec": {
                return this.mGetObject(cr, ATOMIC.DEC);
            }
            case "getBool": {
                return this.mGetObject(cr, ATOMIC.BOOL);
            }
            case "getRow": {
                return this.mGetRow(cr);
            }
            case "get": 
            case "getTable": {
                return this.mGetTable(cr);
            }
        }
        return null;
    }

    private I_Object mGetTable(CallRuntime cr) {
        this.singleRead(cr);
        cr.argsNone();
        if (this.resultset == null) {
            return Nil.NIL;
        }
        try {
            int width = this.resultset.getMetaData().getColumnCount();
            MTable table = new MTable(width);
            do {
                Object[] row = new I_Object[width];
                int i = 1;
                while (i <= width) {
                    Object o = this.resultset.getObject(i);
                    Nil t = o == null ? Nil.NIL : Lib_Convert.toJMo((CallRuntime)cr, (Object)o, (boolean)false);
                    row[i - 1] = t;
                    ++i;
                }
                table.add(row);
            } while (this.resultset.next());
            JMo_Table result = new JMo_Table((I_Table)table);
            if (this.dbms != DBMS.SQLITE3) {
                ArrayList<Str> titles = new ArrayList<Str>(width);
                int column = 1;
                while (column <= width) {
                    String name = this.resultset.getMetaData().getColumnName(column);
                    titles.add(new Str(name));
                    ++column;
                }
                result.setTitles(cr, titles.toArray(new I_Object[titles.size()]));
            }
            this.resultset.close();
            this.resultset = null;
            return result;
        }
        catch (SQLException e) {
            throw new ExtError(cr, "Database-Error", e.getMessage());
        }
    }

    private I_Object mGetRow(CallRuntime cr) {
        this.singleRead(cr);
        cr.argsNone();
        if (this.resultset == null) {
            return Nil.NIL;
        }
        try {
            int breite = this.resultset.getMetaData().getColumnCount();
            ArrayList<Nil> row = new ArrayList<Nil>(breite);
            int i = 1;
            while (i <= breite) {
                Object o = this.resultset.getObject(i);
                Nil t = o == null ? Nil.NIL : Lib_Convert.toJMo((CallRuntime)cr, (Object)o, (boolean)false);
                row.add(t);
                ++i;
            }
            return new JMo_List(row);
        }
        catch (SQLException e) {
            throw new ExtError(cr, "Database-Error", e.getMessage());
        }
    }

    private I_Object mGetObject(CallRuntime cr, ATOMIC type) {
        this.singleRead(cr);
        I_Object[] args = cr.argsFlex((I_Object)this, 0, 1);
        Int col = args.length == 0 ? new Int(1) : cr.argTypeExt(args[0], new Class[]{I_Integer.class, Str.class});
        try {
            if (this.resultset == null) {
                return Nil.NIL;
            }
            if (col instanceof Str) {
                String label = ((Str)col).getValue();
                switch (type) {
                    case STR: {
                        return new Str(this.resultset.getString(label));
                    }
                    case INT: {
                        return new Int(this.resultset.getInt(label));
                    }
                    case LONG: {
                        return new JMo_Long(this.resultset.getLong(label));
                    }
                    case DEC: {
                        return new Dec(this.resultset.getDouble(label));
                    }
                    case BOOL: {
                        return this.resultset.getBoolean(label) ? Bool.TRUE : Bool.FALSE;
                    }
                }
                throw Err.invalid((Object[])new Object[]{type});
            }
            int index = ((I_Integer)col).getIntValue(cr);
            switch (type) {
                case STR: {
                    return new Str(this.resultset.getString(index));
                }
                case INT: {
                    return new Int(this.resultset.getInt(index));
                }
                case LONG: {
                    return new JMo_Long(this.resultset.getLong(index));
                }
                case DEC: {
                    return new Dec(this.resultset.getDouble(index));
                }
                case BOOL: {
                    return this.resultset.getBoolean(index) ? Bool.TRUE : Bool.FALSE;
                }
            }
            throw Err.invalid((Object[])new Object[]{type});
        }
        catch (SQLException e) {
            throw new ExtError(cr, "Database-Error", e.getMessage());
        }
    }

    private I_Object mGetObject(CallRuntime cr) {
        Int col;
        this.singleRead(cr);
        I_Object[] args = cr.argsFlex((I_Object)this, 0, 1);
        Object object = col = args.length == 0 ? new Int(1) : cr.argTypeExt(args[1], new Class[]{I_Integer.class, Str.class});
        if (this.resultset == null) {
            return Nil.NIL;
        }
        try {
            if (col instanceof Str) {
                String label = ((Str)col).getValue();
                Object o = this.resultset.getObject(label);
                return o == null ? Nil.NIL : Lib_Convert.toJMo((CallRuntime)cr, (Object)o, (boolean)false);
            }
            int index = ((I_Integer)col).getIntValue(cr);
            Object o = this.resultset.getObject(index);
            return o == null ? Nil.NIL : Lib_Convert.toJMo((CallRuntime)cr, (Object)o, (boolean)false);
        }
        catch (Err_Runtime e) {
            MOut.temp((Object[])new Object[0]);
            return Nil.NIL;
        }
        catch (SQLException e) {
            MOut.temp((Object[])new Object[0]);
            throw new ExtError(cr, "Database-Error", e.getMessage());
        }
    }

    private void singleRead(CallRuntime cr) {
        if (this.read) {
            throw new ExtError(cr, "Database-Read-Error", "Unfortunately you can only read once from this result.");
        }
        this.read = true;
    }
}

