/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.text.I_PDF_TextItem;
import de.mn77.ext.pdf.create.text.PDF_TextParagraph;
import java.awt.Color;

public class PDF_TextChunk
implements I_PDF_TextItem<PDF_TextParagraph> {
    private String text = null;
    private int[] backgroundRGB;

    public PDF_TextChunk(String text) {
        Err.ifEmpty((String[])new String[]{text});
        this.text = text;
        this.backgroundRGB = new int[]{255, 255, 255};
    }

    public PDF_TextChunk setBackground(int r, int g, int b) {
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{r});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{g});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{b});
        this.backgroundRGB = new int[]{r, g, b};
        return this;
    }

    @Override
    public void draw(Document dokument) {
        Chunk result = new Chunk(this.text);
        result.setBackground(new Color(this.backgroundRGB[0], this.backgroundRGB[1], this.backgroundRGB[2]));
        try {
            dokument.add((Element)result);
        }
        catch (DocumentException e) {
            Err.newRuntime((String)"PDF-Error", (Object[])new Object[]{e});
        }
    }
}

