/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.db.sql;

import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_DataBase;
import de.mn77.ext.db.sql.I_SqlDB;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class A_SqlDB
implements I_SqlDB {
    private Statement sqlStatement;
    private Connection sqlConnection;
    private boolean connected = false;
    private final String host;
    private final String user;
    private final String pass;
    private final String db;
    private final boolean createDB;

    public A_SqlDB(String host, String user, String pass, String db, boolean createDB) {
        this.host = host;
        this.user = user;
        this.pass = pass;
        this.db = db;
        this.createDB = createDB;
    }

    @Override
    public void connect() throws Exception {
        if (this.connected) {
            throw new RuntimeException("Database already connected!");
        }
        if (this.createDB) {
            this.createDB(this.host, this.db, this.user, this.pass);
        }
        this.iConnect(this.host, this.db, this.user, this.pass);
        this.connected = true;
    }

    @Override
    public ResultSet query(String sql) {
        return this.iGetResultSet(sql, true);
    }

    @Override
    public ArrayTable<String> queryTable(String sql) {
        this.iCheckConnection();
        ArrayTable result = null;
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            int width = rset.getMetaData().getColumnCount();
            result = new ArrayTable(width);
            while (rset.next()) {
                Object[] row = (String[])Array.newInstance(String.class, width);
                int i = 1;
                while (i <= width) {
                    Object o = rset.getObject(i);
                    String t = this.iObjectToString(o);
                    row[i - 1] = t;
                    ++i;
                }
                result.add(row);
            }
        }
        catch (SQLException e) {
            Err.show((Throwable)e, (String)"SQL-Error");
        }
        return result;
    }

    @Override
    public List<String> queryRow(String sql) {
        this.iCheckConnection();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            if (rset.next()) {
                int i = 1;
                while (i <= rset.getMetaData().getColumnCount()) {
                    Object o = rset.getObject(i);
                    result.add(this.iObjectToString(o));
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{sql, e});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> queryColumn(String sql) {
        this.iCheckConnection();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            int breite = rset.getMetaData().getColumnCount();
            if (breite == 0) {
                return result;
            }
            while (true) {
                if (!rset.next()) {
                    return result;
                }
                Object o = rset.getObject(1);
                result.add(this.iObjectToString(o));
            }
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{sql, e});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Integer> queryColumnInteger(String sql) {
        this.iCheckConnection();
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            int breite = rset.getMetaData().getColumnCount();
            if (breite == 0) {
                return result;
            }
            while (true) {
                if (!rset.next()) {
                    return result;
                }
                Object o = rset.getObject(1);
                result.add(this.iObjectToInteger(o));
            }
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{sql, e});
        }
        return result;
    }

    @Override
    public Object queryObject(String sql) {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null ? null : rs.getObject(1);
        }
        catch (SQLException e) {
            throw Err.invalid((Object[])new Object[]{sql, e});
        }
    }

    @Override
    public String queryString(String sql) throws Err_DataBase {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null || rs.getObject(1) == null ? null : rs.getString(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public Integer queryInteger(String sql) throws Err_DataBase {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null || rs.getObject(1) == null ? null : Integer.valueOf(rs.getInt(1));
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean query_boolean(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getBoolean(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public float query_float(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getFloat(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public double query_double(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getDouble(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public int query_int(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getInt(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public long query_long(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getLong(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean queryEmpty(String sql) throws Err_DataBase {
        return this.queryObject(sql) == null;
    }

    @Override
    public boolean exec(String sql) throws Err_DataBase {
        this.iCheckConnection();
        try {
            return this.sqlStatement.execute(sql);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public int update(String sql) throws Err_DataBase {
        this.iCheckConnection();
        try {
            boolean hasResults = this.sqlStatement.execute(sql);
            return hasResults ? 0 : this.sqlStatement.getUpdateCount();
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public void close() {
        if (this.connected) {
            try {
                this.sqlStatement.close();
                this.sqlConnection.close();
                this.connected = false;
            }
            catch (SQLException e) {
                Err.invalid((Object[])new Object[]{e});
            }
        }
    }

    @Override
    public void autoCommit(boolean b) {
        this.iCheckConnection();
        try {
            this.sqlConnection.setAutoCommit(b);
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{e});
        }
    }

    @Override
    public void commit() {
        this.iCheckConnection();
        try {
            this.sqlConnection.commit();
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{e});
        }
    }

    @Override
    public void rollback() {
        this.iCheckConnection();
        try {
            this.sqlConnection.rollback();
        }
        catch (SQLException e) {
            Err.invalid((Object[])new Object[]{e});
        }
    }

    @Override
    public Connection getConnection() {
        return this.sqlConnection;
    }

    protected abstract String jdbc(String var1, String var2);

    protected abstract String driver();

    protected void createDB(String host, String db, String user, String pass) throws Exception {
        Err.invalid((Object[])new Object[0]);
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.close();
        this.connected = false;
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet iGetResultSet(String sql, boolean nullAllowed) {
        this.iCheckConnection();
        ResultSet result = null;
        try {
            result = this.sqlStatement.executeQuery(sql);
            Err.ifToSmall((double)1.0, (double)result.getMetaData().getColumnCount());
            if (result.next()) {
                if (nullAllowed) return result;
                if (result.getObject(1) != null) return result;
                throw Err.invalid((Object[])new Object[]{"An empty value cannot be converted", sql, result});
            }
            if (nullAllowed) {
                return null;
            }
            throw Err.invalid((Object[])new Object[]{"ResultSet contains no data", sql, result});
        }
        catch (SQLException e) {
            throw Err.invalid((Object[])new Object[]{e, sql});
        }
    }

    private void iConnect(String host, String db, String user, String pass) throws Exception {
        try {
            Class.forName(this.driver());
            this.sqlConnection = DriverManager.getConnection(this.jdbc(host, db), user, pass);
            this.sqlStatement = this.sqlConnection.createStatement();
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            sb.append(" '");
            if (user != null && user.length() > 0) {
                sb.append(user);
                sb.append('@');
            }
            if (host != null && host.length() > 0) {
                sb.append(host);
                sb.append(':');
            }
            if (db != null && db.length() > 0) {
                sb.append(db);
            }
            sb.append("'");
            throw new Exception(sb.toString());
        }
    }

    private String iObjectToString(Object o) {
        String t;
        String string = t = o == null ? null : o.toString();
        if (t != null && o.getClass() == Timestamp.class) {
            t = t.substring(0, 19);
        }
        return t;
    }

    private Integer iObjectToInteger(Object o) {
        return o == null ? null : Integer.valueOf(Integer.parseInt(o.toString()));
    }

    private void iCheckConnection() {
        if (!this.connected) {
            throw new RuntimeException("Database not connected!");
        }
    }
}

