/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.language.de.preprocess.REPattern;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TelephoneEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"telephone"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    protected final String sTelephone = "(?:[0+][0-9/\\-\\.]+)";
    protected final String sMatchingChars = "[0-9\\+\\/\\-\\.]";
    protected final Pattern reTelephone = Pattern.compile("(?:[0+][0-9/\\-\\.]+)");
    private final Pattern reMatchingChars = Pattern.compile("[0-9\\+\\/\\-\\.]");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (!this.matchTelephone(s)) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 0: {
                expanded = this.expandTelephone(doc, tokens);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchTelephone(String s) {
        return this.reTelephone.matcher(s).matches();
    }

    @Override
    protected int canDealWith(String input, int typeCode) {
        if (typeCode != 0) {
            return -1;
        }
        if (REPattern.digit.matcher(input).find()) {
            return 0;
        }
        return -1;
    }

    protected List<Element> expandTelephone(Document doc, List<Element> tokens) {
        if (tokens == null || tokens.size() == 0) {
            return null;
        }
        ArrayList<Element> exp = new ArrayList<Element>();
        ArrayList<String> parts = new ArrayList<String>();
        Element firstToken = tokens.get(0);
        String firstText = MaryDomUtils.tokenText((Element)firstToken);
        if (firstText != null && firstText.length() > 0 && firstText.charAt(0) == '+') {
            exp.addAll(this.makeNewTokens(doc, "Plus"));
            MaryDomUtils.setTokenText((Element)firstToken, (String)firstText.substring(1));
        }
        for (Element t : tokens) {
            String s = MaryDomUtils.tokenText((Element)t);
            if (!REPattern.digit.matcher(s).find()) continue;
            if (REPattern.onlyDigits.matcher(s).matches()) {
                parts.add(s);
                continue;
            }
            int first = -1;
            int i = 0;
            while (i < s.length()) {
                if (Character.isDigit(s.charAt(i))) {
                    if (first == -1) {
                        first = i;
                    }
                } else if (first != -1) {
                    parts.add(s.substring(first, i));
                    first = -1;
                }
                ++i;
            }
            if (first == -1) continue;
            parts.add(s.substring(first));
        }
        int i = 0;
        while (i < parts.size()) {
            String p = (String)parts.get(i);
            if (p.length() > 3) {
                if (p.length() % 2 != 0) {
                    parts.set(i, p.substring(0, 3));
                    p = p.substring(3);
                } else {
                    parts.set(i, p.substring(0, 2));
                    p = p.substring(2);
                }
                while (p.length() > 0) {
                    parts.add(++i, p.substring(0, 2));
                    p = p.substring(2);
                }
            }
            ++i;
        }
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            exp.addAll(number.expandDigits(doc, (String)it.next(), true));
            Element mtu = exp.get(exp.size() - 1);
            Element t = (Element)mtu.getLastChild();
            t.setAttribute("accent", "unknown");
            if (!it.hasNext()) continue;
            exp.add(MaryDomUtils.createBoundary((Document)doc));
        }
        return exp;
    }
}

