/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"date", "date:dmy", "date:ymd", "date:dm", "date:my", "date:y", "date:m", "date:d", "date:mdy", "date:md"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    private final String[] _monthabbr = new String[]{"Jan", "Januar", "Feb", "Februar", "Mrz", "M\u00e4rz", "Apr", "April", "Jun", "Juni", "Jul", "Juli", "Aug", "August", "Sep", "September", "Okt", "Oktober", "Nov", "November", "Dez", "Dezember", "1", "Januar", "2", "Februar", "3", "M\u00e4rz", "4", "April", "5", "Mai", "6", "Juni", "7", "Juli", "8", "August", "9", "September", "10", "Oktober", "11", "November", "12", "Dezember"};
    private final Map<String, String> monthabbr = MaryUtils.arrayToMap((String[])this._monthabbr);
    protected final String sDay = "(?:0?[1-9]|[12][0-9]|3[01])";
    protected final String sMonth = "(?:0[1-9]|1[0-2])";
    protected final String sMonthword = "(?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter)";
    protected final String sMonthabbr = "(?:Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)";
    protected final String sYear = "(?:([0-9][0-9])?[0-9][0-9])";
    protected final String sDot = "[\\.]";
    protected final String sSlash = "[/]";
    protected final String sMinus = "[\\-]";
    protected final String sMatchingChars = "[0-9/\\.JFMASONDanureb\u00e4zpilgstmkov]";
    protected final String sSeparators = "[\\.]|[/]|[\\-]";
    protected final Pattern reDayMonthYear = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/])((?:0[1-9]|1[0-2]))(?:[\\.]|[/])((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reDayMonthwordYear = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))[\\.]((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reDayMonthabbrYear = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))[\\.]((?:Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez))[\\.]?((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reYearMonthDay = Pattern.compile("((?:([0-9][0-9])?[0-9][0-9]))(?:[\\.]|[/])((?:0[1-9]|1[0-2]))(?:[\\.]|[/])((?:0?[1-9]|[12][0-9]|3[01]))");
    protected final Pattern reYearMonthwordDay = Pattern.compile("((?:([0-9][0-9])?[0-9][0-9]))[\\.]((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))((?:0?[1-9]|[12][0-9]|3[01]))");
    protected final Pattern reYearMonthabbrDay = Pattern.compile("((?:([0-9][0-9])?[0-9][0-9]))[\\.]((?:Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez))[\\.]?((?:0?[1-9]|[12][0-9]|3[01]))");
    protected final Pattern reMonthDayYear = Pattern.compile("((?:0[1-9]|1[0-2]))(?:[\\.]|[/]|[\\-])((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/]|[\\-])((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reMonthwordDayYear = Pattern.compile("((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/]|[\\-])((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reMonthabbrDayYear = Pattern.compile("(?:(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)|(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)\\.)(?:[\\.]|[/]|[\\-])((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/]|[\\-])((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reDayMonth = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/])((?:0[1-9]|1[0-2]))(?:[\\.]|[/])");
    protected final Pattern reDayMonthword = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))[\\.]((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))");
    protected final Pattern reDayMonthabbr = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))[\\.]((?:Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez))[\\.]?");
    protected final Pattern reMonthDay = Pattern.compile("((?:0[1-9]|1[0-2]))(?:[\\.]|[/]|[\\-])((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/]|[\\-])");
    protected final Pattern reMonthwordDay = Pattern.compile("((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.])");
    protected final Pattern reMonthabbrDay = Pattern.compile("(?:(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)|(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)\\.)(?:[\\.]|[/]|[\\-])((?:0?[1-9]|[12][0-9]|3[01]))(?:[\\.]|[/]|[\\-])");
    protected final Pattern reMonthYear = Pattern.compile("((?:0[1-9]|1[0-2]))([/]|[\\.])((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reMonthwordYear = Pattern.compile("((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reMonthabbrYear = Pattern.compile("((?:Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez))[\\.]?((?:([0-9][0-9])?[0-9][0-9]))");
    protected final Pattern reYear = Pattern.compile("(?:([0-9][0-9])?[0-9][0-9])");
    protected final Pattern reMonth = Pattern.compile("((?:0[1-9]|1[0-2]))(?:[\\.])");
    protected final Pattern reMonthword = Pattern.compile("((?:Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Fr\u00fchjahr|Sommer|Herbst|Winter))");
    protected final Pattern reMonthabbr = Pattern.compile("((?:(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)|(Jan|Feb|Mrz|Apr|Jun|Jul|Aug|Sep|Okt|Nov|Dez)\\.))");
    protected final Pattern reDay = Pattern.compile("((?:0?[1-9]|[12][0-9]|3[01]))?:[\\.]");
    private final Pattern reMatchingChars = Pattern.compile("[0-9/\\.JFMASONDanureb\u00e4zpilgstmkov]");
    private Logger logger = MaryUtils.getLogger((String)"DateEP");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchDateDMY(s)) {
                    return 1;
                }
                if (this.matchDateYMD(s)) {
                    return 2;
                }
                if (!this.matchDateDM(s)) break;
                return 3;
            }
            case 1: {
                if (!this.matchDateDMY(s)) break;
                return 1;
            }
            case 2: {
                if (!this.matchDateYMD(s)) break;
                return 2;
            }
            case 3: {
                if (!this.matchDateDM(s)) break;
                return 3;
            }
            case 4: {
                if (!this.matchDateMY(s)) break;
                return 4;
            }
            case 5: {
                if (!this.matchDateY(s)) break;
                return 5;
            }
            case 6: {
                if (!this.matchDateM(s)) break;
                return 6;
            }
            case 7: {
                if (!this.matchDateD(s)) break;
                return 7;
            }
            case 8: {
                if (!this.matchDateMDY(s)) break;
                return 8;
            }
            case 9: {
                if (!this.matchDateMD(s)) break;
                return 9;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandDateDMY(doc, s);
                break;
            }
            case 2: {
                expanded = this.expandDateYMD(doc, s);
                break;
            }
            case 3: {
                expanded = this.expandDateDM(doc, s);
                break;
            }
            case 4: {
                expanded = this.expandDateMY(doc, s);
                break;
            }
            case 5: {
                expanded = this.expandDateYear(doc, s);
                break;
            }
            case 6: {
                expanded = this.expandDateMonth(doc, s);
                break;
            }
            case 7: {
                expanded = this.expandDateDay(doc, s);
                break;
            }
            case 8: {
                expanded = this.expandDateMDY(doc, s);
                break;
            }
            case 9: {
                expanded = this.expandDateMD(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchDateDMY(String s) {
        return this.reDayMonthYear.matcher(s).matches() || this.reDayMonthwordYear.matcher(s).matches() || this.reDayMonthabbrYear.matcher(s).matches();
    }

    protected boolean matchDateYMD(String s) {
        return this.reYearMonthDay.matcher(s).matches() || this.reYearMonthwordDay.matcher(s).matches() || this.reYearMonthabbrDay.matcher(s).matches();
    }

    protected boolean matchDateDM(String s) {
        return this.reDayMonth.matcher(s).matches() || this.reDayMonthword.matcher(s).matches() || this.reDayMonthabbr.matcher(s).matches();
    }

    protected boolean matchDateMY(String s) {
        return this.reMonthYear.matcher(s).matches() || this.reMonthwordYear.matcher(s).matches() || this.reMonthabbrYear.matcher(s).matches();
    }

    protected boolean matchDateY(String s) {
        return this.reYear.matcher(s).matches();
    }

    protected boolean matchDateM(String s) {
        return this.reMonth.matcher(s).matches() || this.reMonthword.matcher(s).matches() || this.reMonthabbr.matcher(s).matches();
    }

    protected boolean matchDateD(String s) {
        return this.reDay.matcher(s).matches();
    }

    protected boolean matchDateMDY(String s) {
        return this.reMonthDayYear.matcher(s).matches() || this.reMonthwordDayYear.matcher(s).matches() || this.reMonthabbrDayYear.matcher(s).matches();
    }

    protected boolean matchDateMD(String s) {
        return this.reMonthDay.matcher(s).matches() || this.reMonthwordDay.matcher(s).matches() || this.reMonthabbrDay.matcher(s).matches();
    }

    protected List<Element> expandDateDMY(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reDayMonthYear.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reDayMonthwordYear.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reDayMonthabbrYear.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String day = reMatcher.group(1);
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        String month = reMatcher.group(2);
        if (monthType == 1) {
            exp.addAll(number.expandOrdinal(doc, String.valueOf(month) + ".", false));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        String year = reMatcher.group(3);
        exp.addAll(this.expandDateYear(doc, year));
        return exp;
    }

    protected List<Element> expandDateYMD(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reYearMonthDay.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reYearMonthwordDay.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reYearMonthabbrDay.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String month = reMatcher.group(3);
        if (monthType == 1) {
            exp.addAll(number.expandOrdinal(doc, String.valueOf(month) + ".", false));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        String day = reMatcher.group(4);
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        String year = reMatcher.group(1);
        exp.addAll(this.expandDateYear(doc, year));
        return exp;
    }

    protected List<Element> expandDateDM(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reDayMonth.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reDayMonthword.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reDayMonthabbr.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String day = reMatcher.group(1);
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        String month = reMatcher.group(2);
        if (monthType == 1) {
            exp.addAll(number.expandOrdinal(doc, String.valueOf(month) + ".", false));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        return exp;
    }

    protected List<Element> expandDateMY(Document doc, String s) {
        String expandedMonth;
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reMonthYear.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reMonthwordYear.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reMonthabbrYear.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String month = reMatcher.group(1);
        if (monthType == 1) {
            if (month.charAt(0) == '0') {
                month = month.substring(1);
            }
            expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        String year = reMatcher.group(3);
        exp.addAll(this.expandDateYear(doc, year));
        return exp;
    }

    protected List<Element> expandDateYear(Document doc, String s) {
        int value;
        ArrayList<Element> exp = new ArrayList<Element>();
        try {
            value = Integer.decode(s);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + s + "\" to long."));
            throw e;
        }
        if (value >= 1100 && value <= 1999) {
            int hundreds = value / 100;
            int rest = value % 100;
            StringBuilder sb = new StringBuilder();
            sb.append(number.expandInteger(hundreds));
            sb.append(" Hundert");
            if (rest != 0) {
                sb.append(" ");
                sb.append(number.expandInteger(rest));
            }
            exp.addAll(this.makeNewTokens(doc, sb.toString(), true, s));
        } else if (value < 10 && s.charAt(0) == '0') {
            exp.addAll(this.makeNewTokens(doc, "null " + number.expandInteger(value), true, s));
        } else {
            exp.addAll(this.makeNewTokens(doc, number.expandInteger(value), true, s));
        }
        return exp;
    }

    protected List<Element> expandDateMonth(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reMonth.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reMonthword.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reMonthabbr.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String month = reMatcher.group(1);
        if (month.charAt(0) == '0') {
            month = month.substring(1);
        }
        if (monthType == 1 || monthType == 3) {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        }
        return exp;
    }

    protected List<Element> expandDateDay(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reDay.matcher(s);
        boolean found = reMatcher.find();
        if (!found) {
            return null;
        }
        String day = reMatcher.group(1);
        if (day.charAt(0) == '0') {
            day = day.substring(1);
        }
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        return exp;
    }

    protected List<Element> expandDateMD(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reMonthDay.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reMonthwordDay.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reMonthabbrDay.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        String day = monthType == 3 ? reMatcher.group(3) : reMatcher.group(2);
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        String month = reMatcher.group(1);
        if (monthType == 1) {
            if (month.charAt(0) == '0') {
                month = month.substring(1);
            }
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        return exp;
    }

    protected List<Element> expandDateMDY(Document doc, String s) {
        String year;
        String day;
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reMonthDayYear.matcher(s);
        boolean found = reMatcher.find();
        int monthType = 1;
        if (!found) {
            reMatcher = this.reMonthwordDayYear.matcher(s);
            found = reMatcher.find();
            monthType = 2;
        }
        if (!found) {
            reMatcher = this.reMonthabbrDayYear.matcher(s);
            found = reMatcher.find();
            monthType = 3;
        }
        if (!found) {
            return null;
        }
        if (monthType == 3) {
            day = reMatcher.group(3);
            year = reMatcher.group(4);
        } else {
            day = reMatcher.group(2);
            year = reMatcher.group(3);
        }
        exp.addAll(number.expandOrdinal(doc, String.valueOf(day) + ".", false));
        String month = reMatcher.group(1);
        if (monthType == 1) {
            if (month.charAt(0) == '0') {
                month = month.substring(1);
            }
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        } else if (monthType == 2) {
            exp.addAll(this.makeNewTokens(doc, month));
        } else {
            String expandedMonth = this.monthabbr.get(month);
            exp.addAll(this.makeNewTokens(doc, expandedMonth));
        }
        exp.addAll(this.expandDateYear(doc, year));
        return exp;
    }
}

