/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.phonemiser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import marytts.exceptions.MaryConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class MorphologyReader {
    public Hashtable<String, String> loadInputModel(InputStream modelStream) throws ParserConfigurationException, SAXException, IOException, MaryConfigurationException {
        Hashtable<String, String> modelTable = new Hashtable<String, String>(40);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(modelStream);
        Element rootNode = doc.getDocumentElement();
        if (rootNode.getNodeName().equals("entries")) {
            NodeList entriesList = rootNode.getChildNodes();
            int i = 0;
            while (i < entriesList.getLength()) {
                if (entriesList.item(i).getNodeType() == 1) {
                    Element entry = (Element)entriesList.item(i);
                    NodeList keyList = entry.getElementsByTagName("key");
                    NodeList valueList = entry.getElementsByTagName("value");
                    if (keyList.getLength() == 1 && valueList.getLength() == 1) {
                        Text textNode;
                        NodeList keyTextNodeList = ((Element)keyList.item(0)).getChildNodes();
                        NodeList valueTextNodeList = ((Element)valueList.item(0)).getChildNodes();
                        String keyString = "";
                        String valueString = "";
                        int a = 0;
                        while (a < keyTextNodeList.getLength()) {
                            if (keyTextNodeList.item(a).getNodeType() == 3) {
                                textNode = (Text)keyTextNodeList.item(a);
                                keyString = String.valueOf(keyString) + textNode.getData().trim();
                            }
                            ++a;
                        }
                        a = 0;
                        while (a < valueTextNodeList.getLength()) {
                            if (valueTextNodeList.item(a).getNodeType() == 3) {
                                textNode = (Text)valueTextNodeList.item(a);
                                valueString = String.valueOf(valueString) + textNode.getData().trim();
                            }
                            ++a;
                        }
                        modelTable.put(keyString, valueString);
                    } else {
                        System.out.println("ERROR: The " + i + "th entry contains wrong number of subElements !!");
                    }
                }
                ++i;
            }
        } else {
            throw new MaryConfigurationException("Document is not wellformed. Top-level element should be <entries>.");
        }
        return modelTable;
    }

    public static String document2String(Element element) {
        String result = null;
        StringWriter strWtr = new StringWriter();
        StreamResult strResult = new StreamResult(strWtr);
        TransformerFactory tfac = TransformerFactory.newInstance();
        try {
            Transformer trans = tfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(element), strResult);
        }
        catch (Exception e) {
            System.err.println("XMLUtils.document2String(): " + e);
        }
        result = strResult.getWriter().toString();
        return result;
    }
}

