/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import marytts.signalproc.sinusoidal.hntm.analysis.pitch.HnmPitchVoicingAnalyzerParams;
import marytts.signalproc.window.Window;
import marytts.util.signal.SignalProcUtils;

public class SinusoidalAnalysisParams {
    public static final float DEFAULT_DELTA_IN_HZ = 50.0f;
    public static final float DEFAULT_ANALYSIS_WINDOW_SIZE = 0.02f;
    public static final float DEFAULT_ANALYSIS_SKIP_SIZE = 0.01f;
    public static final double MIN_ENERGY_TH = 1.0E-50;
    public static final double MIN_PEAK_IN_DB_LOW = -200.0;
    public static final double MIN_PEAK_IN_DB_HIGH = -200.0;
    public static final double MIN_VOICED_FREQ_IN_HZ = 4000.0;
    public static final double MAX_VOICED_FREQ_IN_HZ = 5000.0;
    public static final boolean DEFAULT_REFINE_PEAK_ESTIMATES_PARABOLA = true;
    public static final boolean DEFAULT_REFINE_PEAK_ESTIMATES_BIAS = true;
    public static final int DEFAULT_FREQ_SAMP_NEIGHS_LOW = 2;
    public static final int DEFAULT_FREQ_SAMP_NEIGHS_HIGH = 2;
    public static final float MIN_WINDOW_SIZE = 0.02f;
    public static final int NO_SPEC = -1;
    public static final int LP_SPEC = 0;
    public static final int SEEVOC_SPEC = 1;
    public static final int REGULARIZED_CEPS = 2;
    HnmPitchVoicingAnalyzerParams hnmPitchVoicingAnalyzerParams;
    public int fs;
    public int windowType;
    public int fftSize;
    public int LPOrder;
    public int lifterOrder;
    public double startFreq;
    public double endFreq;
    public boolean bRefinePeakEstimatesParabola;
    public boolean bRefinePeakEstimatesBias;
    public boolean bSpectralReassignment;
    public int ws;
    public int ss;
    public Window win;
    public boolean bAdjustNeighFreqDependent;
    public int minWindowSize;
    public double absMax;
    public double totalEnergy;
    public int regularizedCepstrumWarpingMethod;

    public SinusoidalAnalysisParams(SinusoidalAnalysisParams paramsIn) {
        this.hnmPitchVoicingAnalyzerParams = new HnmPitchVoicingAnalyzerParams(paramsIn.hnmPitchVoicingAnalyzerParams);
        this.fs = paramsIn.fs;
        this.windowType = paramsIn.windowType;
        this.fftSize = paramsIn.fftSize;
        this.LPOrder = paramsIn.LPOrder;
        this.lifterOrder = paramsIn.lifterOrder;
        this.startFreq = paramsIn.startFreq;
        this.endFreq = paramsIn.endFreq;
        this.bRefinePeakEstimatesParabola = paramsIn.bRefinePeakEstimatesParabola;
        this.bRefinePeakEstimatesBias = paramsIn.bRefinePeakEstimatesBias;
        this.bSpectralReassignment = paramsIn.bSpectralReassignment;
        this.ws = paramsIn.ws;
        this.ss = paramsIn.ss;
        this.win = paramsIn.win;
        this.bAdjustNeighFreqDependent = paramsIn.bAdjustNeighFreqDependent;
        this.minWindowSize = paramsIn.minWindowSize;
        this.absMax = paramsIn.absMax;
        this.totalEnergy = paramsIn.totalEnergy;
        this.regularizedCepstrumWarpingMethod = paramsIn.regularizedCepstrumWarpingMethod;
    }

    public SinusoidalAnalysisParams(int samplingRate, double startFreqInHz, double endFreqInHz, int windowTypeIn, boolean bRefinePeakEstimatesParabolaIn, boolean bRefinePeakEstimatesBiasIn, boolean bSpectralReassignmentIn, boolean bAdjustNeighFreqDependentIn) {
        this.hnmPitchVoicingAnalyzerParams = new HnmPitchVoicingAnalyzerParams();
        this.fs = samplingRate;
        this.startFreq = startFreqInHz;
        if (this.startFreq < 0.0) {
            this.startFreq = 0.0;
        }
        this.endFreq = endFreqInHz;
        if (this.endFreq < 0.0) {
            this.endFreq = 0.5 * (double)this.fs;
        }
        this.windowType = windowTypeIn;
        this.setSinAnaFFTSize(SinusoidalAnalysisParams.getDefaultFFTSize(this.fs));
        this.bRefinePeakEstimatesParabola = bRefinePeakEstimatesParabolaIn;
        this.bRefinePeakEstimatesBias = bRefinePeakEstimatesBiasIn;
        this.bSpectralReassignment = bSpectralReassignmentIn;
        this.bAdjustNeighFreqDependent = bAdjustNeighFreqDependentIn;
        this.minWindowSize = (int)Math.floor((double)((float)this.fs * 0.02f) + 0.5);
        if (this.minWindowSize % 2 == 0) {
            ++this.minWindowSize;
        }
        this.absMax = -1.0;
        this.totalEnergy = 0.0;
        this.LPOrder = SignalProcUtils.getLPOrder(this.fs);
        this.lifterOrder = SignalProcUtils.getLifterOrder(this.fs);
    }

    public static int getDefaultFFTSize(int samplingRate) {
        if (samplingRate < 10000) {
            return 1024;
        }
        if (samplingRate < 20000) {
            return 2048;
        }
        return 4096;
    }

    public void setSinAnaFFTSize(int fftSizeIn) {
        this.fftSize = fftSizeIn;
    }
}

