/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import marytts.signalproc.analysis.VoiceQualityFileHeader;
import marytts.util.io.StreamUtils;
import marytts.util.math.MathUtils;

public class VoiceQuality {
    public double[][] vq;
    public VoiceQualityFileHeader params;

    public VoiceQuality() {
        this("");
    }

    public VoiceQuality(String vqFile) {
        this.readVqFile(vqFile);
    }

    public VoiceQuality(int numVqParams, int Fs, float skipSize, float winSize) {
        this.params = new VoiceQualityFileHeader();
        this.params.dimension = numVqParams;
        this.params.samplingRate = 16000;
        this.params.skipsize = skipSize;
        this.params.winsize = winSize;
    }

    public void allocate(int numFramesVq, double[][] par) {
        this.params.numfrm = numFramesVq;
        this.vq = new double[this.params.dimension][numFramesVq];
        int i = 0;
        while (i < this.params.dimension) {
            int j = 0;
            while (j < numFramesVq) {
                this.vq[i][j] = par[i][j];
                ++j;
            }
            ++i;
        }
    }

    public double[] getOQG() {
        return this.vq[0];
    }

    public double[] getGOG() {
        return this.vq[1];
    }

    public double[] getSKG() {
        return this.vq[2];
    }

    public double[] getRCG() {
        return this.vq[3];
    }

    public double[] getIC() {
        return this.vq[4];
    }

    public void printPar() {
        System.out.println("Features Read:\nframe\tOQG\tGOG\tSKG\tRCG\tIC");
        int i = 0;
        while (i < this.params.numfrm) {
            System.out.format("%d\t%.3f %.3f %.3f %.3f %.3f \n", i + 1, this.vq[0][i], this.vq[1][i], this.vq[2][i], this.vq[3][i], this.vq[4][i]);
            ++i;
        }
    }

    public void printMeanStd() {
        System.out.println("Mean +- Standard deviation:\n\tOQG\tGOG\tSKG\tRCG\tIC");
        System.out.format("mean: %.3f\t%.3f\t%.3f\t%.3f\t%.3f\n", MathUtils.mean(this.vq[0], 0), MathUtils.mean(this.vq[1], 0), MathUtils.mean(this.vq[2], 0), MathUtils.mean(this.vq[3], 0), MathUtils.mean(this.vq[4], 0));
        System.out.format("std : %.3f\t%.3f\t%.3f\t%.3f\t%.3f\n", MathUtils.standardDeviation(this.vq[0], 0), MathUtils.standardDeviation(this.vq[1], 0), MathUtils.standardDeviation(this.vq[2], 0), MathUtils.standardDeviation(this.vq[3], 0), MathUtils.standardDeviation(this.vq[4], 0));
    }

    public void applyZscoreNormalization() {
        int i = 0;
        while (i < this.vq.length) {
            this.vq[i] = MathUtils.normalizeZscore(this.vq[i]);
            ++i;
        }
    }

    public void readVqFile(String vqFile) {
        this.params = new VoiceQualityFileHeader();
        if (vqFile != "") {
            DataInputStream stream = null;
            try {
                stream = this.params.readHeader(vqFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    this.vq = VoiceQuality.readVqs(stream, this.params);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writeVqFile(String vqFile) {
        if (vqFile != "") {
            DataOutputStream stream = null;
            try {
                stream = this.params.writeHeader(vqFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    VoiceQuality.writeVqs(stream, this.vq);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeVqs(DataOutputStream stream, double[][] vqs) throws IOException {
        if (stream != null && vqs != null && vqs.length > 0) {
            int i = 0;
            while (i < vqs.length) {
                StreamUtils.writeDoubleArray(stream, vqs[i]);
                ++i;
            }
            stream.close();
        }
    }

    public static double[][] readVqs(DataInputStream stream, VoiceQualityFileHeader params) throws IOException {
        double[][] vqs = null;
        if (stream != null && params.dimension > 0 && params.dimension > 0) {
            vqs = new double[params.dimension][];
            int i = 0;
            while (i < vqs.length) {
                vqs[i] = StreamUtils.readDoubleArray(stream, params.numfrm);
                ++i;
            }
            stream.close();
        }
        return vqs;
    }
}

