/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.visrec.ml.classification.BinaryClassifier;
import javax.visrec.ml.classification.ImageClassifier;
import javax.visrec.ml.classification.NeuralNetBinaryClassifier;
import javax.visrec.ml.classification.NeuralNetImageClassifier;
import javax.visrec.ml.model.ModelCreationException;
import javax.visrec.spi.BinaryClassifierFactory;
import javax.visrec.spi.ImageClassifierFactory;

public final class ClassifierFactoryService {
    private Map<Class<?>, ImageClassifierFactory<?>> imageClassifierFactories;
    private Map<Class<?>, BinaryClassifierFactory<?>> binaryClassifierFactories;
    private static ClassifierFactoryService instance;

    static ClassifierFactoryService getInstance() {
        if (instance == null) {
            instance = new ClassifierFactoryService();
        }
        return instance;
    }

    private ClassifierFactoryService() {
    }

    public <T> ImageClassifier<T> createNeuralNetImageClassifier(NeuralNetImageClassifier.BuildingBlock<T> block) throws ModelCreationException {
        ImageClassifierFactory<?> creator;
        if (this.imageClassifierFactories == null) {
            this.imageClassifierFactories = new HashMap();
            for (ImageClassifierFactory classifierCreator : ServiceLoader.load(ImageClassifierFactory.class)) {
                this.imageClassifierFactories.put(classifierCreator.getImageClass(), classifierCreator);
            }
        }
        if ((creator = this.imageClassifierFactories.get(block.getInputClass())) == null) {
            throw new ModelCreationException("Unsupported image class");
        }
        ImageClassifierFactory<?> castedCreator = creator;
        return castedCreator.create(block);
    }

    public <T> BinaryClassifier<T> createNeuralNetBinaryClassifier(NeuralNetBinaryClassifier.BuildingBlock<T> block) throws ModelCreationException {
        BinaryClassifierFactory<?> creator;
        if (this.binaryClassifierFactories == null) {
            this.binaryClassifierFactories = new HashMap();
            for (BinaryClassifierFactory classifierCreator : ServiceLoader.load(BinaryClassifierFactory.class)) {
                this.binaryClassifierFactories.put(classifierCreator.getTargetClass(), classifierCreator);
            }
        }
        if ((creator = this.binaryClassifierFactories.get(block.getInputClass())) == null) {
            throw new ModelCreationException("Unsupported target class");
        }
        BinaryClassifierFactory<?> castedCreator = creator;
        return castedCreator.create(block);
    }
}

