/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.eval;

import java.util.HashMap;

public class EvaluationMetrics {
    public static final String MEAN_ABSOLUTE_ERROR = "MeanAbsoluteError";
    public static final String MEAN_SQUARED_ERROR = "MeanSquaredError";
    public static final String ROOT_MEAN_SQUARED_ERROR = "RootMeanSquaredError";
    public static final String RESIDUAL_SQUARE_SUM = "ResidualSquareSum";
    public static final String RESIDUAL_STANDARD_ERROR = "ResidualStandardError";
    public static final String R_SQUARED = "RSquared";
    public static final String F_STAT = "FStatistics";
    public static final String ACCURACY = "Accuracy";
    public static final String PRECISION = "Precision";
    public static final String RECALL = "Recall";
    public static final String F1SCORE = "F1Score";
    private final HashMap<String, Float> values = new HashMap();
    private static final HashMap<String, String> description = new HashMap();

    public float get(String key) {
        return this.values.get(key).floatValue();
    }

    public void set(String key, float value) {
        this.values.put(key, Float.valueOf(value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.values.entrySet().stream().forEach(e -> {
            sb.append((String)e.getKey()).append(": ").append(e.getValue());
            if (description.get(e.getKey()) != null) {
                sb.append(" (").append(description.get(e.getKey())).append(")");
            }
            sb.append(System.lineSeparator());
        });
        return sb.toString();
    }

    static {
        description.put(ACCURACY, "How often is classifier correct in total");
        description.put(PRECISION, "How often is classifier correct when it gives positive prediction");
        description.put(RECALL, "When it is actually positive class, how often does it give positive prediction");
        description.put(F1SCORE, "Harmonic average (balance) of precision and recall");
    }
}

