/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.classification;

import java.nio.file.Path;
import javax.visrec.ml.classification.ImageClassifier;
import javax.visrec.ml.model.ModelBuilder;
import javax.visrec.ml.model.ModelCreationException;
import javax.visrec.spi.ServiceProvider;

public interface NeuralNetImageClassifier<T>
extends ImageClassifier<T> {
    public static <IMAGE_CLASS> Builder<IMAGE_CLASS> builder() {
        return new Builder();
    }

    public static class Builder<T>
    implements ModelBuilder<ImageClassifier<T>> {
        private BuildingBlock<T> block;

        private Builder() {
            this.block = new BuildingBlock();
        }

        private Builder(BuildingBlock<T> block) {
            this.block = block;
        }

        public <R> Builder<R> inputClass(Class<R> cls) {
            BuildingBlock newBlock = BuildingBlock.copyWithNewInputClass((BuildingBlock)this.block, cls);
            return new Builder<T>(newBlock);
        }

        public Builder<T> imageWidth(int imageWidth) {
            ((BuildingBlock)this.block).imageWidth = imageWidth;
            return this;
        }

        public Builder<T> imageHeight(int imageHeight) {
            ((BuildingBlock)this.block).imageHeight = imageHeight;
            return this;
        }

        public Builder<T> trainingFile(Path trainingFile) {
            ((BuildingBlock)this.block).trainingPath = trainingFile;
            return this;
        }

        public Builder<T> labelsFile(Path labelsFile) {
            ((BuildingBlock)this.block).labelsFile = labelsFile;
            return this;
        }

        public Builder<T> maxError(float maxError) {
            ((BuildingBlock)this.block).maxError = maxError;
            return this;
        }

        public Builder<T> maxEpochs(int epochs) {
            ((BuildingBlock)this.block).maxEpochs = epochs;
            return this;
        }

        public Builder<T> learningRate(float learningRate) {
            ((BuildingBlock)this.block).learningRate = learningRate;
            return this;
        }

        public Builder<T> threshold(float threshold) {
            ((BuildingBlock)this.block).threshold = threshold;
            return this;
        }

        public Builder<T> exportModel(Path path) {
            ((BuildingBlock)this.block).exportPath = path;
            return this;
        }

        public Builder<T> importModel(Path path) {
            ((BuildingBlock)this.block).importPath = path;
            return this;
        }

        public Builder<T> networkArchitecture(Path architecture) {
            ((BuildingBlock)this.block).networkArchitecture = architecture;
            return this;
        }

        public BuildingBlock<T> getBuildingBlock() {
            return this.block;
        }

        @Override
        public ImageClassifier<T> build() throws ModelCreationException {
            return ServiceProvider.current().getClassifierFactoryService().createNeuralNetImageClassifier(this.block);
        }
    }

    public static class BuildingBlock<T> {
        private int imageWidth;
        private int imageHeight;
        private Path networkArchitecture;
        private Path trainingPath;
        private Path labelsFile;
        private float maxError;
        private float learningRate;
        private Path exportPath;
        private Path importPath;
        private int maxEpochs;
        private float threshold;
        private Class<T> inputCls;

        private BuildingBlock() {
        }

        public Path getNetworkArchitecture() {
            return this.networkArchitecture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public Path getTrainingPath() {
            return this.trainingPath;
        }

        public Path getLabelsPath() {
            return this.labelsFile;
        }

        public float getMaxError() {
            return this.maxError;
        }

        public float getLearningRate() {
            return this.learningRate;
        }

        public Path getExportPath() {
            return this.exportPath;
        }

        public Path getImportPath() {
            return this.importPath;
        }

        public int getMaxEpochs() {
            return this.maxEpochs;
        }

        public float getThreshold() {
            return this.threshold;
        }

        public Class<T> getInputClass() {
            return this.inputCls;
        }

        private static <R> BuildingBlock<R> copyWithNewInputClass(BuildingBlock<?> block, Class<R> cls) {
            BuildingBlock newBlock = new BuildingBlock();
            newBlock.inputCls = cls;
            newBlock.imageHeight = block.imageHeight;
            newBlock.imageWidth = block.imageWidth;
            newBlock.labelsFile = block.labelsFile;
            newBlock.exportPath = block.exportPath;
            newBlock.importPath = block.importPath;
            newBlock.networkArchitecture = block.networkArchitecture;
            newBlock.maxError = block.maxError;
            newBlock.maxEpochs = block.maxEpochs;
            newBlock.learningRate = block.learningRate;
            newBlock.trainingPath = block.trainingPath;
            newBlock.threshold = block.threshold;
            return newBlock;
        }
    }
}

