/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import java.io.Serializable;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.DataSetStatistics;
import org.neuroph.util.data.norm.Normalizer;

public class ZeroMeanNormalizer
implements Normalizer,
Serializable {
    private double[] maxInput;
    private double[] minInput;
    private double[] meanInput;
    private double[] stdInput;

    public ZeroMeanNormalizer(DataSet dataSet) {
        DataSetStatistics stats = new DataSetStatistics(dataSet);
        this.maxInput = stats.inputsMax();
        this.minInput = stats.inputsMin();
        this.meanInput = stats.inputsMean();
        this.stdInput = stats.inputsStandardDeviation(this.meanInput);
    }

    @Override
    public void normalize(DataSet dataSet) {
        for (DataSetRow row : dataSet.getRows()) {
            double[] normalizedInput = row.getInput();
            for (int i = 0; i < dataSet.getInputSize(); ++i) {
                normalizedInput[i] = (normalizedInput[i] - this.meanInput[i]) / this.stdInput[i];
            }
            row.setInput(normalizedInput);
        }
    }
}

