/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.input.Difference;
import org.neuroph.core.transfer.Gaussian;
import org.neuroph.nnet.learning.RBFLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class RBFNetwork
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public RBFNetwork(int inputNeuronsCount, int rbfNeuronsCount, int outputNeuronsCount) {
        this.createNetwork(inputNeuronsCount, rbfNeuronsCount, outputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount, int rbfNeuronsCount, int outputNeuronsCount) {
        NeuronProperties rbfNeuronProperties = new NeuronProperties();
        rbfNeuronProperties.setProperty("inputFunction", Difference.class);
        rbfNeuronProperties.setProperty("transferFunction", Gaussian.class);
        this.setNetworkType(NeuralNetworkType.RBF_NETWORK);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsCount, TransferFunctionType.LINEAR);
        this.addLayer(inputLayer);
        Layer rbfLayer = LayerFactory.createLayer(rbfNeuronsCount, rbfNeuronProperties);
        this.addLayer(rbfLayer);
        Layer outputLayer = LayerFactory.createLayer(outputNeuronsCount, TransferFunctionType.LINEAR);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, rbfLayer);
        ConnectionFactory.fullConnect(rbfLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new RBFLearning());
    }
}

