/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeurophProperties;

public class Gaussian
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double sigma = 0.5;

    public Gaussian() {
    }

    public Gaussian(NeurophProperties properties) {
        try {
            this.sigma = (Double)properties.getProperty("transferFunction.sigma");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    @Override
    public double getOutput(double totalInput) {
        this.output = Math.exp(-Math.pow(totalInput, 2.0) / (2.0 * Math.pow(this.sigma, 2.0)));
        return this.output;
    }

    @Override
    public double getDerivative(double net) {
        double derivative = this.output * (-net / (this.sigma * this.sigma));
        return derivative;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }
}

