/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.events.NeuralNetworkEvent;
import org.neuroph.util.NeuronFactory;
import org.neuroph.util.NeuronProperties;

public class Layer
implements Iterable<Neuron>,
Serializable {
    private static final long serialVersionUID = 4L;
    private NeuralNetwork parentNetwork;
    protected List<Neuron> neurons;
    private String label;

    public Layer() {
        this.neurons = new ArrayList<Neuron>();
    }

    public Layer(int neuronsCount) {
        this.neurons = new ArrayList<Neuron>(neuronsCount);
    }

    public Layer(int neuronsCount, NeuronProperties neuronProperties) {
        this(neuronsCount);
        for (int i = 0; i < neuronsCount; ++i) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            this.addNeuron(neuron);
        }
    }

    public final void setParentNetwork(NeuralNetwork parent) {
        this.parentNetwork = parent;
    }

    public final NeuralNetwork getParentNetwork() {
        return this.parentNetwork;
    }

    public final List<Neuron> getNeurons() {
        return Collections.unmodifiableList(this.neurons);
    }

    public final void addNeuron(Neuron neuron) {
        Objects.requireNonNull(neuron, "Neuron cant be null!");
        neuron.setParentLayer(this);
        this.neurons.add(neuron);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(neuron, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void addNeuron(int index, Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron cant be null!");
        }
        this.neurons.add(index, neuron);
        neuron.setParentLayer(this);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(neuron, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void setNeuron(int index, Neuron neuron) {
        Objects.requireNonNull(neuron, "Neuron can't be null!");
        this.neurons.set(index, neuron);
        neuron.setParentLayer(this);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(neuron, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void removeNeuron(Neuron neuron) {
        int index = this.indexOf(neuron);
        this.removeNeuronAt(index);
    }

    public final void removeNeuronAt(int index) {
        Neuron neuron = this.neurons.get(index);
        neuron.setParentLayer(null);
        neuron.removeAllConnections();
        this.neurons.remove(index);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_REMOVED));
        }
    }

    public final void removeAllNeurons() {
        this.neurons.clear();
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_REMOVED));
        }
    }

    public Neuron getNeuronAt(int index) {
        return this.neurons.get(index);
    }

    public int indexOf(Neuron neuron) {
        return this.neurons.indexOf(neuron);
    }

    public int getNeuronsCount() {
        return this.neurons.size();
    }

    public void calculate() {
        this.neurons.forEach(neuron -> neuron.calculate());
    }

    public void reset() {
        this.neurons.forEach(neuron -> neuron.reset());
    }

    public void initializeWeights(double value) {
        this.neurons.forEach(neuron -> neuron.initializeWeights(value));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isEmpty() {
        return this.neurons.isEmpty();
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.neurons.iterator();
    }
}

