/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.I_ObjectToString;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.MultiCall;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Type;

public class Lib_Convert {
    public static boolean getBoolValue(CallRuntime cr, I_Object o) {
        if (o instanceof Bool) {
            return ((Bool)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Boolean)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.BOOL).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Bool");
    }

    public static char getCharValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getCharValue(cr, o, false);
    }

    public static char getCharValue(CallRuntime cr, I_Object o, boolean cut) {
        if (o instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof Bool) {
            return ((Bool)o).getValue() != false ? (char)'1' : '0';
        }
        if (o instanceof I_AtomicValue) {
            if (cut) {
                return ((I_AtomicValue)o).getValue().toString().charAt(0);
            }
            return ((Character)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.CHAR).getValue()).charValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Char");
    }

    public static double getDoubleValue(CallRuntime cr, I_Object o) {
        if (o instanceof Dec) {
            return Lib_Math.normalize(((Dec)o).getValue(), 10);
        }
        if (o instanceof I_AtomicValue) {
            return Lib_Math.normalize((Double)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.DEC).getValue(), 10);
        }
        throw Lib_Convert.iConvertError(cr, o, "Dec");
    }

    public static float getFloatValue(CallRuntime cr, I_Object o) {
        return (float)Lib_Convert.getDoubleValue(cr, o);
    }

    public static byte getByteValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Byte) {
            return ((JMo_Byte)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Byte)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.BYTE).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Byte");
    }

    public static int getIntValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getIntValue(cr, o, false);
    }

    public static int getIntValue(CallRuntime cr, I_Object o, boolean ord) {
        if (o instanceof Int) {
            return ((Int)o).getValue();
        }
        if (ord && o instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof I_AtomicValue) {
            Object to = Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.INT).getValue();
            if (to == null || to == Nil.NIL) {
                throw Lib_Convert.iConvertError(cr, o, "Int");
            }
            return (Integer)to;
        }
        throw Lib_Convert.iConvertError(cr, o, "Int");
    }

    public static long getLongValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Long) {
            return ((JMo_Long)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (Long)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.LONG).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Long");
    }

    public static BigInteger getBigIntegerValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_BigInt) {
            return ((JMo_BigInt)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (BigInteger)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.BIGINT).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "BigInt");
    }

    public static BigDecimal getBigDecimalValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_BigDec) {
            return ((JMo_BigDec)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return (BigDecimal)Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.BIGDEC).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "BigInt");
    }

    public static String getStringValue(CallRuntime cr, I_Object o) {
        if (o instanceof Str) {
            return ((Str)o).getValue();
        }
        if (o instanceof I_AtomicValue) {
            return "" + Lib_AtomConv.convert(cr, (I_AtomicValue)o, ATOMIC.STR).getValue();
        }
        return o.toString(cr, STYPE.REGULAR);
    }

    public static I_Object getValue(CallRuntime cr, I_Object o) {
        Err.ifNull(o);
        o.initOnce(cr);
        if (o instanceof Var) {
            return ((Var)o).get(cr);
        }
        if (o instanceof Const) {
            return ((Const)o).get(cr);
        }
        if (o instanceof MultiCall) {
            return ((MultiCall)o).getCurrent();
        }
        return o;
    }

    public static JMo_List toJMo(I_Sequence<String> list) {
        Err.ifNull(list);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (String s : list) {
            if (s == null) {
                al.add(Nil.NIL);
                continue;
            }
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    public static JMo_Table toJMo(I_Table<String> tab) {
        Err.ifNull(tab);
        MTable<I_Object> jt = new MTable<I_Object>(tab.getWidth());
        for (I_Sequence i_Sequence : tab) {
            jt.add(new MList(Lib_Convert.toJMo(i_Sequence).getInternalCollection()));
        }
        return new JMo_Table(jt);
    }

    public static I_List<String> toListString(I_Sequence<I_Object> list) {
        Err.ifNull(list);
        MList<String> res = new MList<String>();
        for (I_Object s : list) {
            res.add(Lib_Convert.getStringValue(null, s));
        }
        return res;
    }

    public static I_Object toJMo(CallRuntime cr, Object o, boolean strict) {
        if (o == null) {
            return Nil.NIL;
        }
        Class<?> cls = o.getClass();
        if (cls == String.class) {
            return new Str((String)o);
        }
        if (cls == Boolean.class) {
            return (Boolean)o != false ? Bool.TRUE : Bool.FALSE;
        }
        if (cls == Character.class) {
            return new Char(((Character)o).charValue());
        }
        if (cls == Byte.class) {
            return new JMo_Byte((Byte)o);
        }
        if (cls == Short.class) {
            return new JMo_Short((Short)o);
        }
        if (cls == Integer.class) {
            return new Int((Integer)o);
        }
        if (cls == Long.class) {
            return new JMo_Long((Long)o);
        }
        if (cls == Float.class) {
            return new JMo_Float(((Float)o).floatValue());
        }
        if (cls == Double.class) {
            return new Dec((Double)o);
        }
        if (cls == Date.class) {
            return new JMo_Date(new MDate((Date)o));
        }
        if (cls == Time.class) {
            return new JMo_Time(new MTime((Time)o));
        }
        if (!strict) {
            try {
                if (cls == BigDecimal.class) {
                    return new Dec(((BigDecimal)o).doubleValue());
                }
                if (cls == BigInteger.class) {
                    return new Int(((BigInteger)o).intValueExact());
                }
            }
            catch (ArithmeticException e) {
                throw new ExecError(cr, "Value out of bounds", e.getMessage());
            }
        }
        return new JMo_Java(o);
    }

    public static String toString(Call c) {
        if (c == null) {
            return Nil.NIL.toString();
        }
        return c.toString();
    }

    public static I_Table<String> toTableString(JMo_Table tab) {
        MTable<String> res = new MTable<String>(tab.getInternalObject().getWidth());
        for (I_Sequence i_Sequence : tab.getInternalObject()) {
            res.add((I_Sequence<String>)Lib_Convert.toListString(i_Sequence));
        }
        return res;
    }

    public static String typelistToText(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int pos = 0;
        while (pos < types.length) {
            Class<?> c = types[pos];
            if (pos != 0) {
                sb.append(", ");
            }
            sb.append(Lib_Type.getName(c, null));
            ++pos;
        }
        sb.append(")");
        return sb.toString();
    }

    private static ExecError iConvertError(CallRuntime cr, I_Object o, String neededType) {
        return new ExecError(cr, "Invalid type", "Object cannot be converted to " + neededType + ". Got: " + o.toString(cr, STYPE.IDENT));
    }

    public static I_Object toSafeType(CallRuntime cr, I_Atomic arg, String typeName) {
        switch (arg.getEnum()) {
            case BYTE: {
                switch (typeName) {
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.SHORT);
                    }
                    case "Int": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.INT);
                    }
                    case "Long": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.LONG);
                    }
                    case "Float": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.FLOAT);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.DEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case SHORT: {
                switch (typeName) {
                    case "Int": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.INT);
                    }
                    case "Long": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.LONG);
                    }
                    case "Float": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.FLOAT);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.DEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case INT: {
                switch (typeName) {
                    case "Long": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.LONG);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.DEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case LONG: {
                return typeName.equals("Str") ? Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.STR) : arg;
            }
            case FLOAT: {
                return typeName.equals("Dec") ? Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.DEC) : arg;
            }
            case CHAR: {
                return typeName.equals("Str") ? Lib_AtomConv.convert(cr, (I_AtomicValue)arg, ATOMIC.STR) : arg;
            }
        }
        return arg;
    }

    public static File getFile(CallRuntime cr, I_Object arg) {
        if (arg instanceof JMo_File) {
            return ((JMo_File)arg).getInternalFile();
        }
        if (arg instanceof Str) {
            String value = Lib_Convert.getStringValue(cr, arg);
            return new File(value);
        }
        throw Lib_Convert.iConvertError(cr, arg, "File or Str");
    }

    public static String[] listToStringArray(JMo_List targetArgs) {
        Err.ifNull(targetArgs);
        Collection internalList = targetArgs.getInternalCollection();
        int len = ((ArrayList)internalList).size();
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[i] = Lib_Convert.getStringValue(null, (I_Object)((ArrayList)internalList).get(i));
            ++i;
        }
        return result;
    }

    public static String toString(CallRuntime cr, boolean nested, String delimiter, I_ObjectToString[] arr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(arr[i].toString(cr, nested ? STYPE.NESTED : STYPE.REGULAR));
            ++i;
        }
        return sb.toString();
    }
}

