/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.A_MemLet;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Type;

public class Lib_Arguments {
    public static void checkBlockNecessary(CallRuntime cr) {
        if (!cr.hasBlock()) {
            throw new CodeError(cr, "Invalid function-call", "Block needed for this function");
        }
    }

    public static void checkBlockForbidden(CallRuntime cr) {
        if (cr.hasBlock()) {
            throw new CodeError(cr, "Invalid function-call", "No Block allowed for this function");
        }
    }

    public static I_Object checkArgAdvance(CallRuntime cr, I_Object streamIt, int argIdx, Integer argAmount, Class<?> type, boolean isInstanceInit) {
        I_Object arg = cr.getArgAdvance(streamIt, argIdx);
        return Lib_Arguments.checkArg(cr, arg, type, argIdx, argAmount, isInstanceInit);
    }

    public static I_Object checkArgAdvanceExt(CallRuntime cr, I_Object streamIt, int argIdx, Integer argAmount, Class<?>[] types, boolean isInstanceInit) {
        I_Object arg = cr.getArgAdvance(streamIt, argIdx);
        return Lib_Arguments.checkArgExt(cr, arg, types, argIdx, argAmount, isInstanceInit);
    }

    public static I_Object checkArg(CallRuntime cr, I_Object arg, Class<?> type, Integer argIdx, Integer argAmount, boolean isInstanceInit) {
        I_Object parReal = Lib_Arguments.iCheckArg(cr, arg, type, argIdx, argAmount, isInstanceInit);
        if (parReal == null) {
            throw Lib_Arguments.iCreateInvalidArgTypeError(cr, arg, Lib_Arguments.iTypelistToText(type), argIdx, argAmount, isInstanceInit);
        }
        return parReal;
    }

    public static I_Object checkArgExt(CallRuntime cr, I_Object arg, Class<?>[] types, Integer argIdx, Integer argAmount, boolean isInstanceInit) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            I_Object parReal = Lib_Arguments.iCheckArg(cr, arg, type, argIdx, argAmount, isInstanceInit);
            if (parReal != null) {
                return parReal;
            }
            ++n2;
        }
        throw Lib_Arguments.iCreateInvalidArgTypeError(cr, arg, Lib_Arguments.iTypelistToText(new Class[][]{types}), argIdx, argAmount, isInstanceInit);
    }

    public static I_Object[] checkArgs(CallRuntime cr, I_Object streamIt, Class<?>[] types) {
        if (types == null) {
            if (cr.argCount() > 0) {
                throw new CodeError(cr, "Invalid number of arguments", "No arguments allowed");
            }
            return new I_Object[0];
        }
        if (types.length == 0) {
            Err.invalid("No types definied. If this is okay, then please use: 'cr.args()'");
        }
        Err.ifNull(cr.call);
        I_Object[] args = cr.getArgs(streamIt);
        int oal = args.length;
        Lib_Error.ifArgs(oal, types.length, (Integer)types.length, cr, streamIt);
        int i = 0;
        while (i < oal) {
            args[i] = Lib_Arguments.checkArg(cr, args[i], types[i], i, oal, false);
            ++i;
        }
        return args;
    }

    public static I_Object checkArgsEach(CallRuntime cr, I_Object streamIt, int argIdx, I_Object[] eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getArgsEach(streamIt, argIdx, eachIt);
        return Lib_Arguments.checkArg(cr, result, type, argIdx, null, false);
    }

    public static I_Object checkArgEach(CallRuntime cr, I_Object streamIt, int argIdx, I_Object eachIt, Class<?> type) {
        Err.ifNull(cr.call, streamIt);
        I_Object result = cr.getArgEach(streamIt, argIdx, eachIt);
        return Lib_Arguments.checkArg(cr, result, type, argIdx, null, false);
    }

    public static I_Object[] checkArgsExt(CallRuntime cr, I_Object streamIt, Class<?>[] ... types) {
        I_Object[] args = cr.getArgs(streamIt);
        Lib_Error.ifArgs(args.length, types.length, (Integer)types.length, cr, streamIt);
        int i = 0;
        while (i < args.length) {
            args[i] = Lib_Arguments.checkArgExt(cr, args[i], types[i], i, args.length, false);
            ++i;
        }
        return args;
    }

    public static I_Object[] checkArgsFlex(CallRuntime cr, I_Object streamIt, int par_min, Integer par_max) {
        I_Object[] args = cr.getArgs(streamIt);
        int len = args.length;
        Lib_Error.ifArgs(len, par_min, par_max, cr, streamIt);
        int i = 0;
        while (i < len) {
            args[i] = Lib_Convert.getValue(cr, args[i]);
            ++i;
        }
        return args;
    }

    private static I_Object iCheckArg(CallRuntime cr, I_Object arg, Class<?> type, Integer argIdx, Integer argAmount, boolean isInstanceInit) {
        boolean valid;
        I_Object autoVarConstLet = Lib_Arguments.iAutoVarConstLet(cr, arg, type);
        if (autoVarConstLet != null) {
            return autoVarConstLet;
        }
        I_Object parReal = Lib_Convert.getValue(cr, arg);
        boolean bl = valid = type == null || type.isAssignableFrom(parReal.getClass());
        if (!valid && parReal instanceof A_Atomic && cr.getStrict().isValid_ArgConvert()) {
            String neededTypeName = Lib_Type.getName(type, null);
            parReal = Lib_Convert.toSafeType(cr, (I_Atomic)parReal, neededTypeName);
            valid = Lib_Type.isInstanceOf(parReal, neededTypeName);
        }
        if (!valid) {
            I_Object inst = parReal;
            while (inst != null && inst instanceof Instance) {
                I_Object parent = ((Instance)inst).internalGetParent();
                if (parent != null && type.isAssignableFrom(parent.getClass())) {
                    return parent;
                }
                inst = parent;
            }
        }
        return valid ? parReal : null;
    }

    private static I_Object iAutoVarConstLet(CallRuntime cr, I_Object arg, Class<?> wantedType) {
        if (!cr.getStrict().isValid_AutoVarLet()) {
            return null;
        }
        if (wantedType == A_MemLet.class) {
            if (arg instanceof Var) {
                return new VarLet((Var)arg);
            }
            if (arg instanceof Const) {
                return new ConstLet((Const)arg);
            }
        } else {
            if (wantedType == VarLet.class && arg instanceof Var) {
                return new VarLet((Var)arg);
            }
            if (wantedType == ConstLet.class && arg instanceof Const) {
                return new ConstLet((Const)arg);
            }
        }
        return null;
    }

    private static String iTypelistToText(Class<?> type) {
        return Lib_Type.getTypeString(type, null);
    }

    private static String iTypelistToText(Class<?>[][] types) {
        boolean more;
        StringBuilder sb = new StringBuilder();
        boolean bl = more = types.length > 1;
        if (more) {
            sb.append("(");
        }
        int ica = 0;
        while (ica < types.length) {
            Class<?>[] ca = types[ica];
            if (ica != 0) {
                sb.append(", ");
            }
            sb.append('<');
            int i = 0;
            while (i < ca.length) {
                if (i != 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_Type.getName(ca[i], null));
                ++i;
            }
            sb.append('>');
            ++ica;
        }
        if (more) {
            sb.append(")");
        }
        return sb.toString();
    }

    private static CodeError iCreateInvalidArgTypeError(CallRuntime cr, I_Object arg, String type, Integer argIdx, Integer argAmount, boolean isInstanceInit) {
        String m = cr.call.method;
        if (m != null && !Lib_Function.isMathematicFunction(m)) {
            m = String.valueOf('.') + m;
        }
        String eTarget = isInstanceInit || m == null ? cr.call.object.getTypeName() : m;
        String eArg = argIdx != null && (argAmount == null || argAmount > 1) ? " as argument " + (argIdx + 1) : "";
        String typeDebug = Lib_Type.toIdentWithType(cr, arg);
        String eDet = "Got " + typeDebug + eArg + " for '" + eTarget + "', expected: " + type;
        return new CodeError(cr, "Invalid type of argument", eDet);
    }
}

