/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import java.math.BigDecimal;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicCalc;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Float
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    private final float value;

    public JMo_Float(float val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.FLOAT;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (Float.isNaN(this.value)) {
            return "not_a_number";
        }
        if (this.value == Float.POSITIVE_INFINITY) {
            return "+infinity";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "-infinity";
        }
        return type == STYPE.IDENT || type == STYPE.DESCRIBE ? String.valueOf(this.value) + "f" : "" + this.value;
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new Dec(-this.value - 1.0f);
            }
            case ABS: {
                return new Dec(Math.abs(this.value));
            }
            case EXP: {
                return new Dec(Math.exp(this.value));
            }
            case INC: {
                return new JMo_Float(this.value + 1.0f);
            }
            case DEC: {
                return new JMo_Float(this.value - 1.0f);
            }
            case POW: {
                return new Dec(this.value * this.value);
            }
            case ROOT: {
                return new Dec(Math.sqrt(this.value));
            }
            case LOG10: {
                return new Dec(Math.log10(this.value));
            }
            case LOGN: {
                return new Dec(Math.log(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        double arg = Lib_Convert.getDoubleValue(cr, num);
        return new JMo_Float((float)(inc ? (double)this.value + arg : (double)this.value - arg));
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        if (arg instanceof I_BigNumber) {
            return Lib_AtomicCalc.numberCalcBigDec(cr, op, BigDecimal.valueOf(this.value), Lib_Convert.getBigDecimalValue(cr, arg));
        }
        return Lib_AtomicCalc.numberCalcDec(cr, op, this.value, Lib_Convert.getDoubleValue(cr, arg));
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Float(Float.MIN_VALUE);
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Float(Float.MAX_VALUE);
    }
}

