/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.http.server;

import com.sun.net.httpserver.HttpServer;
import de.mn77.base.error.Err;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.lib.http.server.HttpServerHandler;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_HttpServer
extends A_EventObject {
    private HttpServer server = null;
    private final ArgCallBuffer portCall;

    public JMo_HttpServer(Call arg) {
        this.portCall = new ArgCallBuffer(0, arg);
    }

    @Override
    public void init(CallRuntime cr) {
        this.portCall.init(cr, this, A_IntNumber.class);
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return event.equals("@request");
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "start": {
                return A_Object.stdResult(this.mStart(cr));
            }
            case "stop": {
                return A_Object.stdResult(this.mStop(cr));
            }
        }
        return null;
    }

    private I_Object mStart(CallRuntime cr) {
        cr.argsNone();
        int port = Lib_Convert.getIntValue(cr, this.portCall.get());
        if (this.server != null) {
            throw new ExecError(cr, "Server start failure", "This server is already running");
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
            this.server.createContext("/", new HttpServerHandler(cr, this));
            this.server.setExecutor(null);
            this.server.start();
            cr.getApp().registerFork();
            return this;
        }
        catch (IOException e) {
            throw new ExecError(cr, "Server start failure", e.getMessage());
        }
    }

    private I_Object mStop(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int maxDelaySeconds = args.length == 1 ? Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class)) : 1;
        Err.ifToSmall(0.0, maxDelaySeconds);
        if (this.server != null) {
            this.server.stop(maxDelaySeconds);
            this.server = null;
            cr.getApp().checkExit(true);
        }
        return this;
    }
}

