/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.http.server;

import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_HttpExchange
extends A_ObjectSimple {
    private final HttpExchange ex;
    private String response = "";
    private int responseCode = 200;

    public JMo_HttpExchange(HttpExchange ex) {
        this.ex = ex;
    }

    public String getResponse(CallRuntime cr) {
        return this.response;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setResponseHtml": 
            case "setHtml": {
                this.mSetResponseHtml(cr);
                return this;
            }
            case "setResponseCode": 
            case "setCode": {
                this.mSetResponseCode(cr);
                return this;
            }
            case "getRequestMethod": {
                cr.argsNone();
                return new Str(this.ex.getRequestMethod());
            }
            case "getLocalAddress": {
                cr.argsNone();
                return new Str(this.ex.getLocalAddress().toString());
            }
            case "getProtocol": {
                cr.argsNone();
                return new Str(this.ex.getProtocol());
            }
            case "getRemoteAddress": {
                cr.argsNone();
                return new Str(this.ex.getRemoteAddress().toString());
            }
            case "getRequestURI": {
                cr.argsNone();
                return new Str(this.ex.getRequestURI().toString());
            }
            case "getRequestPath": {
                return this.mGetRequestPath(cr);
            }
            case "getRequestArgs": {
                return this.mGetRequestArgs(cr);
            }
        }
        return null;
    }

    private I_Object mGetRequestArgs(CallRuntime cr) {
        cr.argsNone();
        String uri = this.ex.getRequestURI().toString();
        int idx = uri.indexOf(63);
        if (idx == -1) {
            return new JMo_Map();
        }
        uri = uri.substring(idx + 1);
        ArrayList<I_Object> keys = new ArrayList<I_Object>();
        ArrayList<I_Object> objs = new ArrayList<I_Object>();
        String[] stringArray = uri.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] pair = param.split("=");
            keys.add(new Str(pair[0]));
            String obj = pair.length > 1 ? pair[1] : "";
            objs.add(new Str(obj));
            ++n2;
        }
        return new JMo_Map(keys, objs);
    }

    private I_Object mGetRequestPath(CallRuntime cr) {
        cr.argsNone();
        String uri = this.ex.getRequestURI().toString();
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            uri = uri.substring(0, idx);
        }
        return new Str(uri);
    }

    private void mSetResponseHtml(CallRuntime cr) {
        String s;
        I_Object arg = cr.args(this, Str.class)[0];
        this.response = s = Lib_Convert.getStringValue(cr, arg);
    }

    private void mSetResponseCode(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifNotBetween(cr, 100, 999, i, "HTTP Response code");
        this.responseCode = i;
    }
}

