/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.container;

import de.mn77.base.data.constant.ACCESS;
import de.mn77.base.data.container.I_Box;
import de.mn77.base.error.Err;

public class Box<T>
implements I_Box<T> {
    public final ACCESS access;
    private T value = null;
    private boolean isEmpty = true;
    private final boolean couldBeNull;

    public Box() {
        this(ACCESS.READ_ONLY);
    }

    public Box(ACCESS access) {
        this.access = access;
        this.couldBeNull = true;
    }

    public Box(ACCESS access, T value) {
        this(access, true, value);
    }

    public Box(ACCESS access, boolean couldBeNull, T value) {
        this.access = access;
        this.couldBeNull = couldBeNull;
        if (!couldBeNull) {
            Err.ifNull(value);
        }
        this.set(value);
    }

    @Override
    public synchronized void set(T t) {
        if (!this.couldBeNull) {
            Err.ifNull(t);
        }
        Box.checkWrite(this.access, this.isEmpty);
        this.value = t;
        this.isEmpty = false;
    }

    @Override
    public synchronized T get() {
        Box.checkRead(this.access, this.isEmpty);
        return this.value;
    }

    public String toString() {
        String result = this.getClass().getSimpleName();
        if (this.access != ACCESS.NONE) {
            result = String.valueOf(result) + "(" + this.get() + ")";
        }
        return result;
    }

    private static final void checkWrite(ACCESS access, boolean isEmpty) {
        if (isEmpty || access == ACCESS.FULL) {
            return;
        }
        Err.accessProtected(new Object[0]);
    }

    private static final void checkRead(ACCESS access, boolean isEmpty) {
        if (access != ACCESS.NONE) {
            return;
        }
        Err.accessProtected(new Object[0]);
    }
}

