/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data;

import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class Lib_Array {
    public static <T> T[] concat(Class<T> type, T value, T[] array) {
        T[] result = Lib_Array.newArray(type, array.length + 1);
        System.arraycopy(array, 0, result, 1, array.length);
        result[0] = value;
        return result;
    }

    public static <T> T[] concat(Class<T> type, T[] array, T value) {
        T[] result = Lib_Array.newArray(type, array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = value;
        return result;
    }

    @Deprecated
    public static <T> T[] concat(Class<T> type, T[] array1, T[] array2) {
        T[] result = Lib_Array.newArray(type, array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static <T> T[] cut(Class<T> type, T[] source, int start, int length) {
        T[] result = Lib_Array.newArray(type, length);
        System.arraycopy(source, start - 1, result, 0, length);
        return result;
    }

    public static String[] cutFrom(String[] args, int startIndex) {
        if (startIndex == 0) {
            return args;
        }
        Err.ifToBig(args.length, startIndex);
        if (startIndex == args.length) {
            return new String[0];
        }
        int newLen = args.length - startIndex;
        String[] args2 = new String[newLen];
        System.arraycopy(args, startIndex, args2, 0, newLen);
        return args2;
    }

    public static String[] cutLeft(String[] sa, int items) {
        if (items > sa.length) {
            return sa;
        }
        if (items <= 0) {
            return new String[0];
        }
        String[] args2 = new String[items];
        System.arraycopy(sa, 0, args2, 0, items);
        return args2;
    }

    public static <T> boolean knows(T[] array, T search) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o == null && search == null || o != null && o.equals(search)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean knows(int[] array, int search) {
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == search) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> T[] minus(Class<T> type, T[] array, int index) {
        MList<T> l = new MList<T>();
        l.addAllItems(array);
        l.removePosition(index);
        return l.toArray(type);
    }

    public static <T> T[] removeObject(Class<T> type, T[] array, Object o) {
        ArrayList<T> al = new ArrayList<T>(array.length);
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (!t.equals(o)) {
                al.add(t);
            }
            ++n2;
        }
        return al.toArray(Lib_Array.newArray(type, al.size()));
    }

    public static <T> T[] removeIndex(Class<T> type, T[] array, int idx) {
        Err.ifToSmall(1.0, array.length);
        Err.ifOutOfBounds(0.0, array.length - 1, idx);
        T[] array2 = Lib_Array.newArray(type, array.length - 1);
        if (idx > 0) {
            System.arraycopy(array, 0, array2, 0, idx);
        }
        if (idx < array.length - 1) {
            // empty if block
        }
        System.arraycopy(array, idx + 1, array2, idx, array.length - idx - 1);
        return array2;
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[][] newArray2(Class<T> type, int length1, int length2) {
        return (Object[][])Array.newInstance(type, length1, length2);
    }

    public static <T> int indexOf(T search, T[] arr) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(search)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> void replace(T[] arr, T objOld, T objNew) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(objOld)) {
                arr[i] = objNew;
            }
            ++i;
        }
    }

    public static <T> T[] unique(Class<T> type, T[] arr) {
        int i = 0;
        while (i < arr.length) {
            int j = arr.length - 1;
            while (j > i) {
                if (arr[i].equals(arr[j])) {
                    arr = Lib_Array.removeIndex(type, arr, j);
                }
                --j;
            }
            ++i;
        }
        return arr;
    }

    public static Integer getNextDuplicate(int[] arr) {
        Err.ifNull(new Object[]{arr});
        int i = 0;
        while (i < arr.length) {
            int j = arr.length - 1;
            while (j > i) {
                if (arr[i] == arr[j]) {
                    return arr[i];
                }
                --j;
            }
            ++i;
        }
        return null;
    }

    public static String[] append(Class<String> type, String[] array, String item) {
        int len = array.length;
        String[] na = Lib_Array.newArray(type, len + 1);
        System.arraycopy(array, 0, na, 0, len);
        na[len] = item;
        return na;
    }

    public static String[] begin(Class<String> type, String[] array, String item) {
        int len = array.length;
        String[] na = Lib_Array.newArray(type, len + 1);
        System.arraycopy(array, 0, na, 1, len);
        na[0] = item;
        return na;
    }

    public static void sortGnome(int[] arr, boolean reverse) {
        Err.ifNull(new Object[]{arr});
        int len = arr.length;
        int changes = 1;
        while (changes > 0) {
            int buffer;
            int l;
            changes = 0;
            if (reverse) {
                l = len - 1;
                while (l >= 1) {
                    if (arr[l] > arr[l - 1]) {
                        buffer = arr[l];
                        arr[l] = arr[l - 1];
                        arr[l - 1] = buffer;
                        ++changes;
                    }
                    --l;
                }
                continue;
            }
            l = 0;
            while (l < len - 1) {
                if (arr[l] > arr[l + 1]) {
                    buffer = arr[l];
                    arr[l] = arr[l + 1];
                    arr[l + 1] = buffer;
                    ++changes;
                }
                ++l;
            }
        }
    }
}

