/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.miniconf;

import de.mn77.miniconf.result.MIniConfObject;
import de.mn77.miniconf.result.MIniConfResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_MIniConfResult
extends A_ObjectSimple {
    private final MIniConfResult result;

    public JMo_MIniConfResult(MIniConfResult result) {
        this.result = result;
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "getBool": 
            case "getBoolean": {
                return this.mGetBool(cr);
            }
            case "getInteger": 
            case "getInt": {
                return this.mGetInt(cr);
            }
            case "getDecimal": 
            case "getDec": {
                return this.mGetDec(cr);
            }
            case "getStr": 
            case "getString": {
                return this.mGetStr(cr);
            }
            case "getList": {
                return this.mGetList(cr);
            }
            case "getObject": {
                return this.mGetObject(cr);
            }
            case "getKeys": {
                return this.mGetKeys(cr);
            }
            case "toMap": {
                return this.mToMap(cr);
            }
        }
        return null;
    }

    private I_Object mGetBool(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Boolean b = this.result.getBoolean(key);
            return b == null ? Nil.NIL : Bool.getObject(b);
        }
        I_Object arg1 = cr.argType(args[1], Bool.class);
        boolean def = Lib_Convert.getBoolValue(cr, arg1);
        return Bool.getObject(this.result.getBoolean(key, Boolean.valueOf(def)));
    }

    private I_Object mGetInt(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Integer i = this.result.getInteger(key);
            return i == null ? Nil.NIL : new Int(i);
        }
        I_Object arg1 = cr.argType(args[1], Int.class);
        int def = Lib_Convert.getIntValue(cr, arg1);
        return new Int(this.result.getInteger(key, Integer.valueOf(def)));
    }

    private I_Object mGetDec(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Double d = this.result.getDouble(key);
            return d == null ? Nil.NIL : new Dec(d);
        }
        I_Object arg1 = cr.argType(args[1], Dec.class);
        double def = Lib_Convert.getDoubleValue(cr, arg1);
        return new Dec(this.result.getDouble(key, Double.valueOf(def)));
    }

    private I_Object mGetStr(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            String s = this.result.getString(key);
            return s == null ? Nil.NIL : new Str(s);
        }
        I_Object arg1 = cr.argType(args[1], Str.class);
        String def = Lib_Convert.getStringValue(cr, arg1);
        return new Str(this.result.getString(key, def));
    }

    private I_Object mGetList(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        String[] sa = this.result.getList(key);
        if (sa == null) {
            return args.length == 1 ? Nil.NIL : cr.argType(args[1], JMo_List.class);
        }
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            al.add(new Str(s));
            ++n2;
        }
        return new JMo_List(al);
    }

    private I_Object mGetObject(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 3);
        Lib_Error.ifIs(cr, 2, args.length, "amount of arguments");
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            MIniConfObject mo = this.result.getObject(key);
            if (mo == null) {
                return Nil.NIL;
            }
            ArrayList<I_Object> al1 = new ArrayList<I_Object>();
            al1.add(new Str(mo.type));
            ArrayList<I_Object> al2 = new ArrayList<I_Object>();
            String[] stringArray = mo.args;
            int n = mo.args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al2.add(new Str(s));
                ++n2;
            }
            al1.add(new JMo_List(al2));
            return new JMo_List(al1);
        }
        I_Object arg1 = cr.argType(args[1], Str.class);
        JMo_List arg2 = (JMo_List)cr.argType(args[1], JMo_List.class);
        String arg1s = Lib_Convert.getStringValue(cr, arg1);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        al.add(new Str(arg1s));
        al.add(arg2);
        return new JMo_List(al);
    }

    private I_Object mToMap(CallRuntime cr) {
        cr.argsNone();
        ArrayList<I_Object> keys = new ArrayList<I_Object>();
        ArrayList<I_Object> objects = new ArrayList<I_Object>();
        for (Map.Entry e : this.result.getItems()) {
            keys.add(new Str((String)e.getKey()));
            objects.add(new Str((String)e.getValue()));
        }
        return new JMo_Map(keys, objects);
    }

    private JMo_List mGetKeys(CallRuntime cr) {
        cr.argsNone();
        Set keys = this.result.getKeys();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (String s : keys) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }
}

