/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.crypt;

import de.mn77.lib.crypt.Lib_Base32;
import java.nio.charset.StandardCharsets;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Base32
extends A_ObjectSimple {
    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "encode": {
                return this.iEncode(cr);
            }
            case "decodeToStr": {
                return this.iDecodeToStr(cr);
            }
            case "decodeToBytes": {
                return this.iDecodeToBytes(cr);
            }
        }
        return null;
    }

    private I_Object iEncode(CallRuntime cr) {
        I_Object[] args = cr.argsExt(this, {Bool.class}, {Str.class, JMo_ByteArray.class});
        boolean hex = Lib_Convert.getBoolValue(cr, args[0]);
        byte[] data = null;
        if (args[1] instanceof JMo_ByteArray) {
            data = ((JMo_ByteArray)args[1]).getValue();
        } else {
            String s = Lib_Convert.getStringValue(cr, args[1]);
            data = s.getBytes(StandardCharsets.UTF_8);
        }
        return new Str(hex ? Lib_Base32.encodeHex(data) : Lib_Base32.encode(data));
    }

    private I_Object iDecodeToStr(CallRuntime cr) {
        I_Object[] args = cr.args(this, Bool.class, Str.class);
        boolean hex = Lib_Convert.getBoolValue(cr, args[0]);
        String s = Lib_Convert.getStringValue(cr, args[1]);
        return new Str(new String(hex ? Lib_Base32.decodeToBytesHex(s) : Lib_Base32.decodeToBytes(s), StandardCharsets.UTF_8));
    }

    private I_Object iDecodeToBytes(CallRuntime cr) {
        I_Object[] args = cr.args(this, Bool.class, Str.class);
        boolean hex = Lib_Convert.getBoolValue(cr, args[0]);
        String s = Lib_Convert.getStringValue(cr, args[1]);
        return new JMo_ByteArray(hex ? Lib_Base32.decodeToBytesHex(s) : Lib_Base32.decodeToBytes(s));
    }
}

