/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.cmd;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.stream.UTF8OutputStream;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SYSCMD_IO;
import de.mn77.base.sys.cmd.SysCmdData;
import de.mn77.base.sys.cmd.SysCmdResult;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.thread.A_ParallelProcess;
import java.io.IOException;

public class SysCmd {
    public static void start(String cmd) throws Exception {
        SysCmd.start(cmd, "", false);
    }

    public static void start(String cmd, boolean wait) throws Exception {
        SysCmd.start(cmd, "", wait);
    }

    public static void start(String cmd, String param) throws Exception {
        SysCmd.start(null, cmd, param, false);
    }

    public static void start(String cmd, String param, boolean wait) throws Exception {
        SysCmd.start(null, cmd, param, wait);
    }

    public static void start(I_Directory startDir, String cmd, String args, boolean wait) throws Exception {
        SysCmdData data = new SysCmdData(cmd, args, wait, SYSCMD_IO.LIVE);
        data.startDir.set(startDir);
        new SysCmd().start(data);
    }

    public SysCmdResult start(SysCmdData data) throws Err_Exception {
        Err.ifNull(data, data.command);
        String cmd = data.command;
        if (data.arguments != null && data.arguments.length() > 0) {
            cmd = String.valueOf(cmd) + " " + data.arguments;
        }
        if (data.startDir.get() != null) {
            cmd = "cd \"" + data.startDir.get() + "\"; " + cmd;
        }
        Thread handleOutput = null;
        Thread handleError = null;
        Thread handleInput = null;
        UTF8OutputStream bufferOutput = null;
        UTF8OutputStream bufferError = null;
        try {
            String[] args = null;
            if (Sys.isLinux()) {
                args = new String[]{"sh", "-c", cmd};
            } else if (Sys.isWindows()) {
                args = new String[]{"cmd", "/c", cmd};
            } else if (Sys.isMac()) {
                args = new String[]{"open", "-a", cmd};
            } else {
                throw Err.todo("Unknown system: " + Sys.getOsName() + " " + Sys.getOsVersion());
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(args);
            switch (data.inout) {
                case LIVE: {
                    pb.inheritIO();
                    break;
                }
                case DISCARD: {
                    pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                    pb.redirectError(ProcessBuilder.Redirect.DISCARD);
                    break;
                }
                case CUSTOM: {
                    break;
                }
                case BUFFER: {
                    pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                }
            }
            Process process = pb.start();
            if (!data.wait) {
                SysCmdResult sysCmdResult = new SysCmdResult(process);
                return sysCmdResult;
            }
            switch (data.inout) {
                case BUFFER: {
                    bufferOutput = new UTF8OutputStream();
                    handleOutput = Lib_Stream.connectWithInputBuffer(process.getInputStream(), bufferOutput);
                    bufferError = new UTF8OutputStream();
                    handleError = Lib_Stream.connectWithInputBuffer(process.getErrorStream(), bufferError);
                    break;
                }
                case CUSTOM: {
                    if (data.streamOutput.get() != null) {
                        handleOutput = Lib_Stream.connectWithInputBuffer(process.getInputStream(), data.streamOutput.get());
                    }
                    if (data.streamError.get() != null) {
                        handleError = Lib_Stream.connectWithInputBuffer(process.getErrorStream(), data.streamError.get());
                    }
                    if (data.streamInput.get() == null) break;
                    handleInput = Lib_Stream.connectWithOutputBuffer(data.streamInput.get(), process.getOutputStream());
                }
            }
            int result = process.waitFor();
            if (handleOutput != null) {
                handleOutput.interrupt();
                while (!((A_ParallelProcess)handleOutput).isFinished()) {
                    Thread.yield();
                }
            }
            if (handleError != null) {
                handleError.interrupt();
                while (!((A_ParallelProcess)handleError).isFinished()) {
                    Thread.yield();
                }
            }
            if (bufferOutput != null) {
                bufferOutput.close();
            }
            if (bufferError != null) {
                bufferError.close();
            }
            SysCmdResult sysCmdResult = new SysCmdResult(process, bufferOutput == null ? null : bufferOutput.getString(), bufferError == null ? null : bufferError.getString(), result);
            return sysCmdResult;
        }
        catch (IOException e) {
            throw Err.wrap(e, "External Process was not clean executed!", data);
        }
        catch (InterruptedException e1) {
            throw Err.wrap(e1, "External Process was not clean executed!", data);
        }
        finally {
            try {
                if (bufferOutput != null) {
                    bufferOutput.close();
                }
                if (bufferError != null) {
                    bufferError.close();
                }
                if (handleOutput != null) {
                    handleOutput.interrupt();
                }
                if (handleError != null) {
                    handleError.interrupt();
                }
                if (handleInput != null) {
                    handleInput.interrupt();
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, new Object[0]);
            }
        }
    }
}

