/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort.algo;

import de.mn77.base.data.constant.RELATION;
import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.algo.I_SortAlgo;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;

public abstract class A_SortAlgo
implements I_SortAlgo {
    @Override
    public final void sort(I_Sortable<?> tab, int ... columnOrder) {
        Err.ifNull(tab);
        if (columnOrder == null || columnOrder.length == 0) {
            columnOrder = new int[]{1};
        }
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Err.ifOutOfBounds(1.0, tab.getWidth(), Math.abs(i));
            ++n2;
        }
        if (columnOrder.length > 10) {
            MOut.warning("The width is greater than 10!");
        }
        if (tab.size() > 100000) {
            MOut.warning("The size is greater than 100000!");
        }
        this.sortImpl(tab, columnOrder);
    }

    protected abstract void sortImpl(I_Sortable<?> var1, int ... var2);

    protected boolean isHeavier(I_Sortable<?> tab, int row, int thanRow, int ... columnOrder) {
        return this.getRelation(tab, row, thanRow, columnOrder) == RELATION.IS_GREATER;
    }

    protected RELATION getRelation(I_Sortable<?> tab, int row1, int row2, int ... columnOrder) {
        RELATION result = RELATION.IS_EQUAL;
        int columnOrderIdx = 0;
        while (result == RELATION.IS_EQUAL && columnOrder.length > columnOrderIdx) {
            Object o2;
            int n = Math.abs(columnOrder[columnOrderIdx]);
            Object o1 = tab.get(n, row1);
            if (Lib_Compare.isEqual(o1, o2 = tab.get(n, row2))) {
                result = RELATION.IS_EQUAL;
            } else {
                boolean ig = Lib_Compare.isGreater(o1, o2);
                if (columnOrder[columnOrderIdx] < 0) {
                    ig = !ig;
                }
                result = ig ? RELATION.IS_GREATER : RELATION.IS_SMALLER;
            }
            ++columnOrderIdx;
        }
        return result;
    }
}

