/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class Lib_StrFormat {
    public static String format(CallRuntime cr, String s, I_Object obj) {
        int len = s.length();
        String value = Lib_Convert.getStringValue(cr, obj);
        if (len == 2) {
            return value;
        }
        int fieldLen = 0;
        boolean cutOverflow = false;
        Enum align = null;
        Character type = Character.valueOf('s');
        String sSpec = "";
        int stage = 1;
        int start = 1;
        int i = 0;
        while (i < len) {
            char c = s.charAt(++i);
            if (stage == 1) {
                if (c >= '0' && c <= '9') continue;
                String part = s.substring(start, i);
                fieldLen = part.length() == 0 ? 0 : Integer.parseInt(part);
                start = i--;
                stage = (byte)(stage + 1);
                continue;
            }
            if (stage == 2) {
                start = i--;
                if (c == '!' || c == '?') {
                    cutOverflow = c == '!';
                }
                stage = (byte)(stage + 1);
                continue;
            }
            if (stage == 3) {
                start = i--;
                if (c == '<') {
                    align = POSITION_H.LEFT;
                } else if (c == '^') {
                    align = POSITION_H.CENTER;
                } else if (c == '>') {
                    align = POSITION_H.RIGHT;
                }
                stage = (byte)(stage + 1);
                continue;
            }
            if (stage == 4) {
                if (c == 'i' || c == 'd' || c == 'c' || c == 's' || c == 'b' || c == 't') {
                    type = Character.valueOf(c);
                } else {
                    type = Character.valueOf((char)(obj instanceof Bool ? 98 : (obj instanceof Char ? 99 : (obj instanceof Dec ? 100 : (obj instanceof Int ? 105 : (obj instanceof JMo_Byte ? 105 : (obj instanceof JMo_Float ? 100 : (obj instanceof JMo_Long ? 105 : (obj instanceof JMo_Short ? 105 : 115)))))))));
                    --i;
                }
                start = i + 1;
                stage = (byte)(stage + 1);
                continue;
            }
            if (stage != 5) continue;
            sSpec = s.substring(start, len - 1);
            break;
        }
        switch (type.charValue()) {
            case 's': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                value = Lib_StrFormat.iSpecString(cr, value, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
            case 'c': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                value = Lib_StrFormat.iSpecChar(cr, obj, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
            case 'i': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                value = Lib_StrFormat.iSpecInt(cr, obj, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
            case 'd': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                value = Lib_StrFormat.iSpecDec(cr, obj, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
            case 'b': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                value = Lib_StrFormat.iSpecBool(cr, obj, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
            case 't': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                value = Lib_StrFormat.iSpecType(cr, obj, sSpec);
                return FormString.width(fieldLen, ' ', value, align, cutOverflow);
            }
        }
        throw Err.todo(s, value, type);
    }

    public static final Group2<Boolean, String> getNext(String s, int offset) {
        boolean formatOpen = false;
        int pos = offset;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '{') {
                    if (pos == offset) {
                        formatOpen = true;
                    } else {
                        return new Group2<Boolean, String>(false, s.substring(offset, pos));
                    }
                }
                if (c == '}' && formatOpen) {
                    return new Group2<Boolean, String>(true, s.substring(offset, pos + 1));
                }
            }
            ++pos;
        }
        return new Group2<Boolean, String>(formatOpen, s.substring(offset));
    }

    private static String iSpecString(CallRuntime cr, String os, String sSpec) {
        if (sSpec.length() == 0) {
            return os;
        }
        Lib_StrFormat.checkStringSpec(cr, sSpec);
        boolean escape = false;
        Character caseChange = null;
        Character quote = null;
        char[] cArray = sSpec.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'e': {
                    escape = true;
                    break;
                }
                case 'C': 
                case 'c': 
                case 'l': 
                case 'u': {
                    caseChange = Character.valueOf(c);
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    quote = Character.valueOf(c);
                    break;
                }
                default: {
                    throw Lib_StrFormat.iSpecThrow(cr, "String", sSpec);
                }
            }
            ++n2;
        }
        boolean escaped = false;
        String result = os;
        if (caseChange != null) {
            switch (caseChange.charValue()) {
                case 'u': {
                    result = result.toUpperCase();
                    break;
                }
                case 'l': {
                    result = result.toLowerCase();
                    break;
                }
                case 'c': {
                    result = Lib_String.capitalize(result, true);
                    break;
                }
                case 'C': {
                    result = Lib_String.capitalize(result, false);
                    break;
                }
                default: {
                    Err.impossible(caseChange);
                }
            }
        }
        if (quote != null) {
            switch (quote.charValue()) {
                case '1': {
                    result = FormString.quote(result, '\'', '\\', escape);
                    escaped = true;
                    break;
                }
                case '2': {
                    result = FormString.quote(result, '\"', '\\', escape);
                    escaped = true;
                    break;
                }
                case '3': {
                    result = FormString.quote(result, '\'', '\'', escape);
                    escaped = true;
                    break;
                }
                case '4': {
                    result = FormString.quote(result, '\"', '\"', escape);
                    escaped = true;
                    break;
                }
                default: {
                    Err.impossible(caseChange);
                }
            }
        }
        if (escape && !escaped) {
            result = FormString.escapeSpecialChars(result, false, false);
        }
        return result;
    }

    private static void checkStringSpec(CallRuntime cr, String s) {
        boolean quote = false;
        boolean escape = false;
        boolean cases = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'e': {
                    if (escape) {
                        throw Lib_StrFormat.iSpecThrow(cr, "String", "Duplicated 'e': " + s);
                    }
                    escape = true;
                    break;
                }
                case 'C': 
                case 'c': 
                case 'l': 
                case 'u': {
                    if (cases) {
                        throw Lib_StrFormat.iSpecThrow(cr, "String", "Only one case type is allowed [l,u,c,C] but got: " + s);
                    }
                    cases = true;
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    if (quote) {
                        throw Lib_StrFormat.iSpecThrow(cr, "String", "Only one quote type is allowed [1,2,3,4] but got: " + s);
                    }
                    quote = true;
                    break;
                }
                default: {
                    throw Lib_StrFormat.iSpecThrow(cr, "String", "Invalid char '" + c + "' in: " + s);
                }
            }
            ++n2;
        }
    }

    private static String iSpecChar(CallRuntime cr, I_Object o, String sSpec) {
        String os = "" + Lib_Convert.getCharValue(cr, o, true);
        if (sSpec.length() == 0) {
            return os;
        }
        if (sSpec.length() > 1) {
            throw Lib_StrFormat.iSpecThrow(cr, "Character", sSpec);
        }
        switch (sSpec.charAt(0)) {
            case 'u': {
                return os.toUpperCase();
            }
            case 'l': {
                return os.toLowerCase();
            }
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Character", sSpec);
    }

    private static String iSpecInt(CallRuntime cr, I_Object o, String sSpec) {
        String os = "" + Lib_Convert.getIntValue(cr, o, false);
        if (sSpec.length() == 0) {
            return os;
        }
        if (sSpec.length() > 1) {
            throw Lib_StrFormat.iSpecThrow(cr, "Integer", sSpec);
        }
        if (sSpec.charAt(0) == '+') {
            return os.charAt(0) == '-' ? os : String.valueOf('+') + os;
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Integer", sSpec);
    }

    private static String iSpecDec(CallRuntime cr, I_Object o, String sSpec) {
        double d = Lib_Convert.getDoubleValue(cr, o);
        if (sSpec.length() == 0) {
            return "" + d;
        }
        String sign = "";
        if (sSpec.charAt(0) == '+') {
            sign = d < 0.0 ? "" : "+";
            sSpec = sSpec.substring(1);
        }
        String os = "" + d;
        if (sSpec.equals("0")) {
            os = "" + Math.round(d);
        } else if (sSpec.length() > 0) {
            try {
                int digits = Integer.parseInt(sSpec);
                os = FormNumber.round(d, digits);
            }
            catch (NumberFormatException e) {
                throw Lib_StrFormat.iSpecThrow(cr, "Decimal", sSpec);
            }
        }
        return String.valueOf(sign) + os;
    }

    private static String iSpecBool(CallRuntime cr, I_Object o, String sSpec) {
        boolean b = Lib_Convert.getBoolValue(cr, o);
        if (sSpec.length() == 0) {
            return "" + b;
        }
        if (sSpec.length() > 1) {
            throw Lib_StrFormat.iSpecThrow(cr, "Bool", sSpec);
        }
        switch (sSpec.charAt(0)) {
            case 'u': {
                return b ? "TRUE" : "FALSE";
            }
            case 'l': {
                return b ? "true" : "false";
            }
            case 'C': 
            case 'c': {
                return b ? "True" : "False";
            }
        }
        throw Lib_StrFormat.iSpecThrow(cr, "Bool", sSpec);
    }

    private static String iSpecType(CallRuntime cr, I_Object o, String sSpec) {
        if (sSpec.length() != 0) {
            throw Lib_StrFormat.iSpecThrow(cr, "Type", sSpec);
        }
        I_Object o2 = Lib_Convert.getValue(cr, o);
        return o2.getType(cr).toString();
    }

    private static ExecError iSpecThrow(CallRuntime cr, String type, String sSpec) {
        throw new ExecError(cr, "Invalid Secification for " + type + "-Format", sSpec);
    }
}

