/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.tdef;

import de.mn77.base.MN;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.parser.tdef.TypeInfo;
import org.jaymo_lang.util.Lib_Comply;
import org.jaymo_lang.util.Lib_Parser;

public class ParseTDef {
    public Type parse(Parser_Script parser, Type type, String s) {
        TypeInfo info = this.scan(parser, s);
        Group3<FunctionPar[], Integer, Boolean> g = Lib_Parser.getFunctionPars(parser, type.getBlock(), info.args == null ? "" : info.args, '(', ')');
        if (info.extend_type != null) {
            Block current = type.getBlock();
            String ext = info.extend_type;
            if (info.extend_pars != null) {
                ext = String.valueOf(ext) + info.extend_pars;
            }
            I_ParseObject po = parser.app.parsemanager_obj.getParser(current, ext, parser.getDebugInfo(), true);
            Group2<I_Object, String> extG = po.parse(parser, current, ext);
            if (!MN.isEmpty((String)extG.o2)) {
                throw new ParseError("Invalid type definition", "Unusable statement for extending type.", parser.getDebugInfo());
            }
            return new Type(info.name, (FunctionPar[])g.o1, info.abFunction, info.control, (Boolean)g.o3, parser, (I_Object)extG.o1, parser.getDebugInfo());
        }
        return new Type(info.name, (FunctionPar[])g.o1, info.abFunction, info.control, (Boolean)g.o3, parser, parser.getDebugInfo());
    }

    private TypeInfo scan(Parser_Script parser, String s) {
        boolean isControl = false;
        String name = null;
        String args = null;
        String ext_type = null;
        String ext_pars = null;
        String abFunction = null;
        PHASE phase = PHASE.NAME;
        int start = 0;
        boolean nameLastIsSpace = false;
        boolean after_pars_space = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (phase) {
                case NAME: {
                    if (c == '(') {
                        if (nameLastIsSpace) {
                            throw new ParseError("Invalid type definition", "Please remove whitespace(s) between type name and '('", parser.getDebugInfo());
                        }
                        name = ParseTDef.checkName(parser, s.substring(start, i));
                        phase = PHASE.PARS;
                        start = i;
                        break;
                    }
                    if (c == '=' || nameLastIsSpace && c >= 'a' && c <= 'z') {
                        name = ParseTDef.checkName(parser, s.substring(start, i));
                        phase = PHASE.ABFUNCTION;
                        start = i;
                        break;
                    }
                    if (c == '^') {
                        name = ParseTDef.checkName(parser, s.substring(start, i));
                        phase = PHASE.EXT_TYPE;
                        start = i;
                        break;
                    }
                    if (c == ' ') {
                        nameLastIsSpace = true;
                        break;
                    }
                    if (c == '\t') {
                        throw new ParseError("Invalid type definition", "Please remove tabulator after: " + s.substring(0, i), parser.getDebugInfo());
                    }
                    nameLastIsSpace = false;
                    break;
                }
                case PARS: {
                    if (c == '(') {
                        String group = Lib_Parser.group('(', ')', s.substring(i), parser.getDebugInfo());
                        i += group.length() + 1;
                        break;
                    }
                    if (c == ')') {
                        args = s.substring(start, i + 1);
                        phase = PHASE.AFTER_PARS;
                        start = i + 1;
                        break;
                    }
                    if (c != '^') break;
                    throw new ParseError("Invalid type definition", "Closing bracket is missing.", parser.getDebugInfo());
                }
                case AFTER_PARS: {
                    if (c == '!') {
                        Lib_Parser.checkControl(s, i, parser);
                        ++i;
                        if (after_pars_space) {
                            throw new ParseError("Invalid type definition", "Spaces between closing bracket and modifier '?'!", parser.getDebugInfo());
                        }
                        isControl = true;
                        break;
                    }
                    if (c == '^') {
                        phase = PHASE.EXT_TYPE;
                        start = i;
                        break;
                    }
                    if (c == '=') {
                        phase = PHASE.ABFUNCTION;
                        start = i;
                        break;
                    }
                    if (c == ' ') {
                        after_pars_space = true;
                        break;
                    }
                    throw new ParseError("Invalid type definition", "Invalid chars after closing bracket. Want '^' or '=', but got: " + s.substring(i), parser.getDebugInfo());
                }
                case EXT_TYPE: {
                    if (c == '=') {
                        if (start + 1 < i) {
                            ext_type = ParseTDef.checkExtName(parser, s.substring(start, i));
                        }
                        phase = PHASE.ABFUNCTION;
                        start = i;
                        break;
                    }
                    if (c != '(') break;
                    if (start + 1 < i) {
                        ext_type = ParseTDef.checkExtName(parser, s.substring(start, i));
                    }
                    phase = PHASE.EXT_PARS;
                    start = --i;
                    break;
                }
                case EXT_PARS: {
                    if (c != '(') break;
                    ext_pars = Lib_Parser.group('(', ')', s.substring(i), parser.getDebugInfo());
                    phase = PHASE.ABFUNCTION;
                    i = i + ext_pars.length() + 1;
                    start = i + 1;
                    ext_pars = String.valueOf('(') + ext_pars.trim() + ')';
                }
            }
            ++i;
        }
        if (phase == PHASE.NAME) {
            name = ParseTDef.checkName(parser, s.substring(start));
        }
        if (phase == PHASE.PARS || phase == PHASE.EXT_PARS) {
            throw new ParseError("Invalid type definition", "Missing closing bracket: " + s, parser.getDebugInfo());
        }
        if (phase == PHASE.EXT_TYPE && start < s.length()) {
            ext_type = ParseTDef.checkExtName(parser, s.substring(start));
        }
        if (phase == PHASE.ABFUNCTION) {
            abFunction = ParseTDef.checkAbFunction(parser, s.substring(start));
        }
        return new TypeInfo(name, isControl, args, ext_type, ext_pars, abFunction);
    }

    private static String checkName(Parser_Script parser, String name) {
        if ((name = name.strip()).length() == 0) {
            return null;
        }
        if (!Lib_Comply.checkTypeName(name)) {
            throw new ParseError("Invalid type name", "Illegal type name: " + name, parser.getDebugInfo());
        }
        return name;
    }

    private static String checkExtName(Parser_Script parser, String name) {
        if ((name = name.trim()).length() <= 1) {
            return null;
        }
        return ParseTDef.checkName(parser, name.substring(1));
    }

    private static String checkAbFunction(Parser_Script parser, String name) {
        if ((name = name.strip()).length() == 0) {
            return null;
        }
        if (name.charAt(0) != '=') {
            throw new ParseError("Invalid type definition", "Missing '=' for default function", parser.getDebugInfo());
        }
        return name.substring(1).trim();
    }

    private static enum PHASE {
        NAME,
        PARS,
        AFTER_PARS,
        EXT_TYPE,
        EXT_PARS,
        ABFUNCTION;

    }
}

