/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Comply;

public class ParseObj_Var
implements I_ParseObject {
    private static final String matching = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789?\u00bf";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 >= 'a' && c0 <= 'z';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Err.ifNull(current);
        String var = FilterString.matchingLeft(matching, s);
        if (!Lib_Comply.checkVarName(var)) {
            throw new CodeError("Invalid variable name", "This variable name can't be used: " + var, parser.getDebugInfo());
        }
        String rem = s.substring(var.length());
        if (var.equals("it?")) {
            throw new CodeError("Invalid modifier for 'it'!", "The magic variable 'it' is always 'open' and this can't reduced to 'nilable'!", parser.getDebugInfo());
        }
        if (var.equals("it")) {
            var = "it??";
        }
        Var vo = (Var)current.getVarManager().use_ParseTime(parser, var, false);
        return new Group2<I_Object, String>(vo, rem);
    }
}

