/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.data.group.Group2;
import java.util.ArrayList;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.object.pseudo.MultiCall;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.event.I_ParserEvStart;
import org.jaymo_lang.parser.event.ParserEvStart_Args;
import org.jaymo_lang.parser.event.ParserEvStart_Direct;
import org.jaymo_lang.parser.func.I_ParseFunc;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_StringParser;

public class Parser_Call {
    private static int multiCallCounter = 0;
    private static final I_ParserEvStart[] parsers_EvStart = new I_ParserEvStart[]{new ParserEvStart_Direct(), new ParserEvStart_Args()};

    private Parser_Call() {
    }

    public static Call parseCall(Parser_Script parser, Block current, String s, boolean isArgument) {
        Group2<I_Object, String> go = Parser_Call.parseObject(parser, current, s, isArgument);
        I_Object obj = (I_Object)go.o1;
        s = (String)go.o2;
        s = Parser_Call.comment(s);
        Call first = null;
        Call last = null;
        while (s != null && s.length() > 0) {
            Call c = null;
            char c0 = s.charAt(0);
            s = s.trim();
            boolean dot = false;
            if (c0 == '.' && s.length() >= 2 && !s.startsWith("..")) {
                c0 = (s = s.substring(1)).charAt(0);
                if (c0 == ' ' || c0 == '\t') {
                    throw new CodeError("Space or tab after a dot", "Got: ." + s, parser.getDebugInfo());
                }
                dot = true;
            }
            if (c0 == '@') {
                c = Parser_Call.parseEventStart(parser, current, obj, s);
                s = "";
            } else {
                if (!dot) {
                    if (!((c0 < 'a' || c0 > 'z') && c0 != '_' || obj != null && obj instanceof A_MagicVar && ((A_MagicVar)obj).withoutDot())) {
                        throw new ParseError("Missing dot or mathematical sign.", s, parser.getDebugInfo());
                    }
                    if (c0 == '\u00b4' || c0 == '`') {
                        throw new ParseError("Missing dot or mathematical sign.", s, parser.getDebugInfo());
                    }
                }
                Group2<Call, String> res = Parser_Call.parseFunction(parser, current, obj, s, isArgument);
                c = (Call)res.o1;
                s = (String)res.o2;
            }
            if (first == null) {
                first = c;
            }
            if (last != null) {
                last.setStream(c);
            }
            last = c;
            obj = null;
            if (s == null || s.length() == 0) {
                Call last2 = c.searchLastCall();
                if (c.searchLastCall() != null) {
                    last = last2;
                }
            }
            if (s == null) continue;
            s = Parser_Call.comment(s);
        }
        if (first == null) {
            first = new Call(current, obj, parser.getDebugInfo());
        }
        return first;
    }

    public static Call parseCallMulti(Parser_Script parser, Block current, String s, int key) {
        Call c = Parser_Call.parseCall(parser, current, s, true);
        MultiCall mc = new MultiCall(key, c);
        return new Call(current, mc, parser.getDebugInfo());
    }

    public static Group2<I_Object, String> parseObject(Parser_Script parser, Block current, String s, boolean isArgument) {
        if ((s = s.trim()).length() == 0) {
            throw new ParseError("Empty string", "Object or argument is missing!", parser.getDebugInfo());
        }
        I_ParseObject po = parser.app.parsemanager_obj.getParser(current, s, parser.getDebugInfo(), isArgument);
        return po.parse(parser, current, s);
    }

    public static Call[] parseArguments(Parser_Script parser, Block current, String s) {
        if (s.length() == 0) {
            return new Call[0];
        }
        s = s.trim();
        ArrayList<Call> args = new ArrayList<Call>();
        while (s.length() > 0) {
            Group2<Call, String> g = Parser_Call.parseArgumentItem(parser, current, s.trim());
            args.add((Call)g.o1);
            s = (String)g.o2;
        }
        return args.toArray(new Call[args.size()]);
    }

    private static String comment(String s) {
        return (s = s.trim()).length() == 0 ? "" : (s.charAt(0) == '#' ? "" : s);
    }

    private static Call parseEventStart(Parser_Script parser, Block current, I_Object obj, String s) {
        I_ParserEvStart[] i_ParserEvStartArray = parsers_EvStart;
        int n = parsers_EvStart.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParserEvStart pes = i_ParserEvStartArray[n2];
            if (pes.hits(s)) {
                return pes.parse(parser, current, obj, s);
            }
            ++n2;
        }
        String detail = s.indexOf(46) > -1 ? "No attached stream allowed, but got" : (s.indexOf(32) > -1 ? "Open argument is currently not allowed" : "Got");
        throw new ParseError("Invalid Event-Start", String.valueOf(detail) + ": " + s, parser.getDebugInfo());
    }

    public static Group2<Call, String> parseFunction(Parser_Script parser, Block current, I_Object obj, String s, boolean isArgument) {
        I_ParseFunc pf = parser.app.parsemanager_func.getParser(obj, s, parser.getDebugInfo());
        return pf.parse(parser, current, obj, s, isArgument);
    }

    private static Group2<Call, String> parseArgumentItem(Parser_Script parser, Block current, String s) {
        Group2<String, String> result = Lib_StringParser.getNextPar(s, parser.getDebugInfo());
        String arg = (String)result.o1;
        String rem = (String)result.o2;
        int key = ++multiCallCounter;
        int aLen = arg.length();
        if (aLen > 0 && arg.charAt(aLen - 1) == '.') {
            if (!arg.endsWith("...")) {
                throw new ParseError("Open end of argument", "Argument ends with a dot: " + s, parser.getDebugInfo());
            }
            arg = arg.substring(0, arg.length() - 3);
            arg = String.valueOf(arg) + "\u00b6" + key;
            return new Group2<Call, String>(Parser_Call.parseCallMulti(parser, current, arg, key), rem);
        }
        return new Group2<Call, String>(Parser_Call.parseCall(parser, current, arg, true), rem);
    }
}

