/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.Lib_Version;
import java.io.File;
import org.jaymo_lang.JayMo;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_Script;

public class Parser_App {
    private boolean terminalModeRaw = false;
    private boolean debug = false;

    public Parser_App() {
        this(false);
    }

    public Parser_App(boolean versionUpdate) {
        if (versionUpdate) {
            this.versionUpdate(versionUpdate);
        }
    }

    public I_VersionData getVersion() {
        return JayMo.VERSION;
    }

    public void setTerminalRawMode(boolean inRawMode) {
        this.terminalModeRaw = inRawMode;
    }

    public void setDebug() {
        this.debug = true;
    }

    public String getVersionString(boolean withBuild, boolean withDate) {
        String format = "%1.%2.%3%D" + (withBuild ? " (%b)" : "") + (withDate ? " - %dd.mm.yyyy" : "");
        return JayMo.VERSION.toFormat(format);
    }

    public App parseFile(File file) throws Err_FileSys {
        App app = new App(this.terminalModeRaw, this.debug);
        this.parseFile(app, file);
        return app;
    }

    public void parseFile(App app, File file) throws Err_FileSys {
        String source = Lib_TextFile.read(file, true);
        this.iParseText(app, file.getParent(), file.getName(), source);
    }

    public App parseText(String source) {
        App app = new App(this.terminalModeRaw, this.debug);
        this.iParseText(app, null, null, source);
        return app;
    }

    public void parseText(App app, String source) {
        this.iParseText(app, null, null, source);
    }

    public App parseText(String basePath, String filePath, String code) {
        App app = new App(this.terminalModeRaw, this.debug);
        this.iParseText(app, basePath, filePath, code);
        return app;
    }

    private void iParseText(App app, String basePath, String fileInfo, String code) {
        Parser_Script ps = new Parser_Script(app, basePath, fileInfo, code);
        ps.parse();
    }

    private void versionUpdate(boolean update) {
        try {
            Lib_Version.init(JayMo.VERSION, false, update);
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
    }
}

