/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.wiki77;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.struct.keymap.KeyList;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.wiki77.Lib_Wiki77;
import java.util.ArrayList;

public class Wiki77_Parser {
    StringBuilder output = new StringBuilder();
    private int ul = 0;
    private int ol = 0;
    private boolean table = false;
    private boolean code = false;
    private boolean paragraph = false;
    boolean bold = false;
    boolean italic = false;
    boolean underline = false;
    boolean stroke = false;
    private boolean nowiki = false;
    private boolean ignore = false;
    private final KeyList<String, String> headlines;

    public Wiki77_Parser() {
        this(null);
    }

    public Wiki77_Parser(KeyList<String, String> headlines) {
        this.headlines = headlines;
    }

    /*
     * Unable to fully structure code
     */
    public String parse(String raw) {
        if (this.output.length() > 0) {
            Err.invalid(new Object[]{"Currently only one wiki can converted."});
        }
        lines = Lib_Wiki77.parseLines(raw);
        block6: for (String line : lines) {
            if (this.ignore) {
                this.parseText(line);
                continue;
            }
            leading = Lib_Wiki77.parseLeading(line);
            if (leading == null) ** GOTO lbl-1000
            switch (((Character)leading.o1).charValue()) {
                case '=': {
                    this.closeAll();
                    this.output.append("<h" + leading.o2 + ">" + Lib_Wiki77.removeTrailing(Lib_Wiki77.specialChars(line), (Integer)leading.o2 + 1, '=') + "</h" + leading.o2 + ">\n");
                    break;
                }
                case '*': {
                    this.ul = this.listOpen(false, this.ul, (Integer)leading.o2);
                    this.output.append("<li>");
                    this.parseText((String)leading.o3);
                    this.output.append("</li>\n");
                    break;
                }
                case '#': {
                    this.ol = this.listOpen(true, this.ol, (Integer)leading.o2);
                    this.output.append("<li>");
                    this.parseText((String)leading.o3);
                    this.output.append("</li>\n");
                    break;
                }
                case '-': {
                    if ((Integer)leading.o2 >= 3) {
                        this.closeAll();
                        this.output.append("<hr>\n");
                        break;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.closeAllLists();
                    if (line.startsWith("  ")) {
                        this.closeAll(CALLER.CODE);
                        if (!this.code) {
                            if (line.equals("  ")) continue block6;
                            this.output.append("<pre><code>");
                            this.code = true;
                        }
                        text = Lib_Wiki77.specialChars(line.substring(2));
                        this.output.append(String.valueOf(text) + "\n");
                        break;
                    }
                    if (this.code) {
                        this.code = false;
                        while (this.output.charAt(this.output.length() - 1) == '\n') {
                            this.output.setLength(this.output.length() - 1);
                        }
                        this.output.append("</code></pre>\n");
                    }
                    if (line.startsWith("|")) {
                        this.closeAll(CALLER.TABLE);
                        if (!this.table) {
                            this.table = true;
                            this.output.append("<table border=0 cellspacing=0 cellpadding=0>\n");
                        }
                        this.parseTable(line);
                        break;
                    }
                    if (this.table) {
                        this.table = false;
                        this.output.append("</table>\n");
                    }
                    if (line.startsWith("!!")) {
                        this.closeAll();
                        this.box(this.output, line);
                        break;
                    }
                    if (line.trim().length() == 0) {
                        this.closeAll();
                        break;
                    }
                    if (this.paragraph) {
                        this.output.append('\n');
                    } else {
                        this.output.append("<p>\n");
                        this.paragraph = true;
                    }
                    this.parseText(line);
                }
            }
        }
        this.closeAll();
        return this.output.toString();
    }

    private boolean parseText(String text) {
        boolean result = false;
        I_List<String> lines = Lib_Wiki77.splitLines(text);
        int lineIndex = 1;
        while (lineIndex <= lines.size()) {
            String line = (String)lines.get(lineIndex);
            if (lineIndex > 1) {
                result = true;
                if (!this.code && !line.startsWith("  ")) {
                    this.output.append("<br />\n");
                }
            }
            boolean result2 = this.parseTextLine(line);
            if (!result) {
                result = result2;
            }
            ++lineIndex;
        }
        if (this.code) {
            this.code = false;
            while (this.output.charAt(this.output.length() - 1) == '\n') {
                this.output.setLength(this.output.length() - 1);
            }
            this.output.append("</code></pre>\n");
        }
        if (this.nowiki) {
            this.nowiki = false;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseTextLine(String line) {
        result = false;
        if (!this.ignore) {
            if (line.startsWith("  ")) {
                if (!this.code) {
                    this.output.append("<pre><code>");
                    this.code = true;
                }
                text = Lib_Wiki77.specialChars(line.substring(2));
                text = Lib_Wiki77.convertIgnore(text);
                this.output.append(String.valueOf(text) + "\n");
                return true;
            }
            if (this.code) {
                this.code = false;
                while (this.output.charAt(this.output.length() - 1) == '\n') {
                    this.output.setLength(this.output.length() - 1);
                }
                this.output.append("</code></pre>\n");
            }
        }
        i = 0;
        while (i < line.length()) {
            block37: {
                block40: {
                    block39: {
                        block38: {
                            block36: {
                                if (!this.nowiki || !line.startsWith("}}}", i)) break block36;
                                this.nowiki = false;
                                i += 2;
                                break block37;
                            }
                            if (!line.startsWith("{{{", i)) break block38;
                            this.nowiki = true;
                            i += 2;
                            break block37;
                        }
                        if (!this.ignore || !line.startsWith("*/", i)) break block39;
                        this.ignore = false;
                        ++i;
                        break block37;
                    }
                    if (this.nowiki || this.code || !line.startsWith("/*", i)) break block40;
                    this.ignore = true;
                    ++i;
                    break block37;
                }
                if (this.nowiki || this.ignore) ** GOTO lbl-1000
                if (line.startsWith("**", i)) {
                    this.output.append(this.bold != false ? "</strong>" : "<strong>");
                    this.bold = this.bold == false;
                    ++i;
                } else if (line.startsWith("//", i)) {
                    this.output.append(this.italic != false ? "</em>" : "<em>");
                    this.italic = this.italic == false;
                    ++i;
                } else if (line.startsWith("__", i)) {
                    this.output.append(this.underline != false ? "</u>" : "<u>");
                    this.underline = this.underline == false;
                    ++i;
                } else if (line.startsWith("--", i)) {
                    this.output.append(this.stroke != false ? "</stroke>" : "<stroke>");
                    this.stroke = this.stroke == false;
                    ++i;
                } else if (line.startsWith("http://", i) || line.startsWith("https://", i) || line.startsWith("ftp://", i) || line.startsWith("file://", i)) {
                    i = this.parseLinkDirect(line, i);
                } else if (line.startsWith("[[", i)) {
                    i = this.parseLink(line, i);
                } else if (line.startsWith("{{", i)) {
                    i = this.parseImage(line, i);
                } else if (line.startsWith(":-)", i)) {
                    this.output.append("\ud83d\ude42");
                    i += 2;
                } else if (line.startsWith(";-)", i)) {
                    this.output.append("\ud83d\ude09");
                    i += 2;
                } else if (line.startsWith(":-(", i)) {
                    this.output.append("\ud83d\ude41");
                    i += 2;
                } else if (line.startsWith(":-/", i)) {
                    this.output.append("\ud83e\udd14");
                    i += 2;
                } else if (line.startsWith(":-|", i)) {
                    this.output.append("\ud83d\ude10");
                    i += 2;
                } else if (line.startsWith(":-D", i)) {
                    this.output.append("\ud83d\ude02");
                    i += 2;
                } else if (line.startsWith("O:-)", i)) {
                    this.output.append("\ud83d\ude07");
                    i += 3;
                } else if (!this.ignore) {
                    text = Lib_Wiki77.specialChars(line.charAt(i));
                    if (text.length() > 0) {
                        result = true;
                    }
                    this.output.append(text);
                }
            }
            ++i;
        }
        return result;
    }

    private int parseLink(String line, int i) {
        String s;
        ArrayList<String> l;
        int tabs;
        int end = line.indexOf("]]", i);
        if (end == -1) {
            end = line.length() - 1;
        }
        if ((tabs = (l = ConvString.toList("|", s = line.substring(i + 2, end))).size()) < 1 || tabs > 2) {
            throw new Err_Runtime("Invalid Link-Definition: " + line, new Object[0]);
        }
        String link = l.get(0);
        String text = l.get(l.size() - 1);
        String target = "_blank";
        String script = "";
        if (this.isInternalLink(link)) {
            target = "_self";
            script = " onClick=\"loadArticle(this,'" + link + "'); return false;\"";
            if (this.headlines != null && link.equals(text)) {
                if (!this.headlines.getKeys().contains(link)) {
                    throw new Err_Runtime("Dead Wiki-Link: " + link, new Object[0]);
                }
                text = String.valueOf('\"') + this.headlines.get(link, link) + '\"';
            }
            link = "?page=" + link;
        }
        this.output.append("<a href='" + link + "' target='" + target + "'" + script + ">" + text + "</a>");
        return end + 1;
    }

    private int parseLinkDirect(String line, int i) {
        int end = line.length();
        int endSpace = line.indexOf(32, i);
        int endTab = line.indexOf(9, i);
        if (endSpace > -1 && endSpace < end) {
            end = endSpace;
        }
        if (endTab > -1 && endTab < end) {
            end = endTab;
        }
        String link = line.substring(i, end);
        String target = "_blank";
        this.output.append("<a href='" + link + "' target='" + "_blank" + "'" + ">" + link + "</a>");
        return end + 1;
    }

    private boolean isInternalLink(String link) {
        char[] cArray = link.toLowerCase().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-')) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int parseImage(String line, int i) {
        String s;
        ArrayList<String> l;
        int end = line.indexOf("}}", i);
        if (end == -1) {
            end = line.length() - 1;
        }
        if ((l = ConvString.toList("|", s = line.substring(i + 2, end))).size() == 1) {
            this.output.append("<img src=\"" + l.get(0) + "\" />");
        }
        if (l.size() >= 2) {
            this.output.append("<img src=\"" + l.get(0) + "\" title=\"" + l.get(1) + "\" />");
        }
        return end + 1;
    }

    private void parseTable(String line) {
        if ((line = line.trim().substring(1)).endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        I_List<String> row = Lib_Wiki77.splitTable(line);
        this.output.append("<tr>\n");
        for (String cell : row) {
            if (cell.trim().length() == 0) {
                this.output.append("<td>&nbsp;</td>\n");
                continue;
            }
            boolean header = false;
            if (cell.charAt(0) == '=') {
                header = true;
                cell = cell.substring(1);
            }
            String align = null;
            boolean intendLeft = cell.startsWith(" ") && !cell.startsWith("  ");
            boolean intendRight = cell.endsWith(" ");
            if (intendLeft && intendRight) {
                align = "text-align:center";
            } else if (intendLeft) {
                align = "text-align:right";
            } else if (intendRight) {
                align = "text-align:left";
            }
            this.output.append(header ? "<th" : "<td");
            if (align != null) {
                this.output.append(" style=\"" + align + "\"");
            }
            this.output.append(">");
            if (intendLeft) {
                cell = cell.substring(1);
            }
            if (intendRight) {
                cell = cell.substring(0, cell.length() - 1);
            }
            this.parseText(cell);
            if (cell.trim().length() == 0) {
                this.output.append("&nbsp;");
            }
            this.output.append(header ? "</th>\n" : "</td>\n");
        }
        this.output.append("</tr>\n");
    }

    private int listOpen(boolean orderedList, int current, int dest) {
        while (current > dest) {
            this.output.append(orderedList ? "</ol>\n" : "</ul>\n");
            --current;
        }
        if (current < dest) {
            this.closeAll(CALLER.LIST);
            while (current < dest) {
                this.output.append(orderedList ? "<ol>\n" : "<ul>\n");
                ++current;
            }
        }
        return current;
    }

    private void closeAllLists() {
        while (this.ul > 0) {
            this.output.append("</ul>\n");
            --this.ul;
        }
        while (this.ol > 0) {
            this.output.append("</ol>\n");
            --this.ol;
        }
    }

    private void closeAll() {
        this.closeAll(CALLER.OTHER);
    }

    private void closeAll(CALLER caller) {
        this.closeText();
        if (caller != CALLER.LIST) {
            this.closeAllLists();
        }
        if (caller != CALLER.PARAGRAPH && this.paragraph) {
            this.output.append("\n</p>\n");
            this.paragraph = false;
        }
        if (caller != CALLER.CODE && this.code) {
            this.output.append("</code></pre>\n");
            this.code = false;
        }
        if (caller != CALLER.TABLE && this.table) {
            this.output.append("</table>\n");
            this.table = false;
        }
        this.nowiki = false;
    }

    private void closeText() {
        if (this.bold) {
            this.output.append("</strong>");
            this.bold = false;
        }
        if (this.italic) {
            this.output.append("</em>");
            this.italic = false;
        }
        if (this.underline) {
            this.output.append("</u>");
            this.underline = false;
        }
        if (this.stroke) {
            this.output.append("</stroke>");
            this.stroke = false;
        }
    }

    private void box(StringBuilder sb, String line) {
        line = line.substring(2).trim();
        String[] sa = ConvString.toStringArray("|", line);
        sb.append("<p class='mwiki-box'>\n");
        if (sa.length == 2) {
            sb.append("<span class='headline'>");
            this.parseText(sa[0].trim());
            sb.append("</span><br>\n");
            this.parseText(sa[1].trim());
            sb.append("\n");
        } else {
            this.parseText(sa[0].trim());
            sb.append("\n");
        }
        sb.append("</p>\n");
    }

    private static enum CALLER {
        OTHER,
        LIST,
        TABLE,
        CODE,
        PARAGRAPH;

    }
}

